/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;

public class BloodyArrowBonus
extends GemBonus {
    public static Codec<BloodyArrowBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, BloodyArrowBonus::new));
    protected final Map<LootRarity, Data> values;

    public BloodyArrowBonus(Map<LootRarity, Data> values) {
        super(Apotheosis.loc("bloody_arrow"), new GemClass("ranged_weapon", (Set<LootCategory>)ImmutableSet.of((Object)LootCategory.BOW, (Object)LootCategory.CROSSBOW)));
        this.values = values;
    }

    @Override
    public void onArrowFired(ItemStack gem, LootRarity rarity, LivingEntity user, AbstractArrow arrow) {
        Data d = this.values.get(rarity);
        if (Affix.isOnCooldown(this.getId(), d.cooldown, user)) {
            return;
        }
        user.m_6469_(user.m_269291_().m_269079_(Apoth.DamageTypes.CORRUPTED), user.m_21233_() * d.healthCost);
        arrow.m_36781_(arrow.m_36789_() * (double)d.dmgMultiplier);
        Affix.startCooldown(this.getId(), user);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        Data d = this.values.get(rarity);
        MutableComponent cooldown = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)d.cooldown)});
        return Component.m_237110_((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(d.healthCost * 100.0f), Affix.fmt(100.0f * d.dmgMultiplier), cooldown}).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public BloodyArrowBonus validate() {
        Preconditions.checkNotNull(this.values);
        this.values.forEach((k, v) -> {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
        });
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    record Data(float healthCost, float dmgMultiplier, int cooldown) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("health_cost").forGetter(Data::healthCost), (App)Codec.FLOAT.fieldOf("damage_mult").forGetter(Data::dmgMultiplier), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
    }
}

