/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class SocketTooltipRenderer
implements ClientTooltipComponent {
    public static final ResourceLocation SOCKET = new ResourceLocation("apotheosis", "textures/gui/socket.png");
    private final SocketComponent comp;
    private final int spacing;

    public SocketTooltipRenderer(SocketComponent comp) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.spacing = 9 + 2;
        this.comp = comp;
    }

    public int m_142103_() {
        return this.spacing * this.comp.gems.size();
    }

    public int m_142069_(Font font) {
        int maxWidth = 0;
        for (ItemStack gem : this.comp.gems) {
            maxWidth = Math.max(maxWidth, font.m_92852_((FormattedText)SocketTooltipRenderer.getSocketDesc(this.comp.socketed, gem)) + 12);
        }
        return maxWidth;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics gfx) {
        for (int i = 0; i < this.comp.gems.size(); ++i) {
            gfx.m_280398_(SOCKET, x, y + this.spacing * i, 0, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        for (ItemStack gem : this.comp.gems()) {
            if (!gem.m_41619_()) {
                PoseStack pose = gfx.m_280168_();
                pose.m_85836_();
                pose.m_85841_(0.5f, 0.5f, 1.0f);
                gfx.m_280203_(gem, 2 * x + 1, 2 * y + 1);
                pose.m_85849_();
            }
            y += this.spacing;
        }
    }

    public void m_142440_(Font pFont, int pX, int pY, Matrix4f pMatrix4f, MultiBufferSource.BufferSource pBufferSource) {
        for (int i = 0; i < this.comp.gems.size(); ++i) {
            pFont.m_272077_(SocketTooltipRenderer.getSocketDesc(this.comp.socketed, this.comp.gems.get(i)), (float)(pX + 12), (float)(pY + 1 + this.spacing * i), 0xAABBCC, true, pMatrix4f, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public static Component getSocketDesc(ItemStack socketed, ItemStack gemStack) {
        GemInstance inst = GemInstance.socketed(socketed, gemStack);
        if (!inst.isValid()) {
            return Component.m_237115_((String)"socket.apotheosis.empty");
        }
        return inst.getSocketBonusTooltip();
    }

    public record SocketComponent(ItemStack socketed, List<ItemStack> gems) implements TooltipComponent
    {
    }
}

