/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.library;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryContainer;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryTile;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.packets.ButtonClickMessage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;

public class EnchLibraryScreen
extends AbstractContainerScreen<EnchLibraryContainer> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/library.png");
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected List<LibrarySlot> data = new ArrayList<LibrarySlot>();
    protected EditBox filter = null;
    private static DecimalFormat f = new DecimalFormat("##.#");

    public EnchLibraryScreen(EnchLibraryContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.f_97726_ = 176;
        this.f_96543_ = 176;
        this.f_97727_ = 241;
        this.f_96544_ = 241;
        this.f_97730_ = 7;
        this.f_97728_ = 7;
        this.f_97729_ = 4;
        this.f_97731_ = 149;
        this.containerChanged();
        container.setNotifier(this::containerChanged);
    }

    protected void m_7856_() {
        super.m_7856_();
        int n = this.getGuiLeft() + 91;
        int n2 = this.getGuiTop() + 20;
        Objects.requireNonNull(this.f_96547_);
        int n3 = n2 + 9 + 2;
        Objects.requireNonNull(this.f_96547_);
        this.filter = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, n, n3, 78, 9 + 4, this.filter, (Component)Component.m_237113_((String)"")));
        this.filter.m_94151_(t -> this.containerChanged());
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 && this.m_7222_() == this.filter) {
            this.m_7522_(null);
            this.filter.m_93692_(false);
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.m_7222_() == this.filter) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gfx);
        super.m_88315_(gfx, mouseX, mouseY, partialTicks);
        this.m_280072_(gfx, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics gfx, int mouseX, int mouseY) {
        super.m_280072_(gfx, mouseX, mouseY);
        LibrarySlot libSlot = this.getHoveredSlot(mouseX, mouseY);
        if (libSlot != null) {
            int targetLevel;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            MutableComponent name = Component.m_237115_((String)libSlot.ench.m_44704_()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFF80)).m_131162_(Boolean.valueOf(true)));
            if (AttributesLib.getTooltipFlag().m_7050_()) {
                name = name.m_7220_((Component)Component.m_237113_((String)(" [" + BuiltInRegistries.f_256876_.m_7981_((Object)libSlot.ench) + "]")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131162_(Boolean.valueOf(false))));
            }
            list.add(name);
            if (I18n.m_118936_((String)(libSlot.ench.m_44704_() + ".desc")) || AttributesLib.getTooltipFlag().m_7050_()) {
                MutableComponent txt = Component.m_237115_((String)(libSlot.ench.m_44704_() + ".desc")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)));
                list.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)txt, this.getGuiLeft() - 16, txt.m_7383_()));
                list.add(Component.m_237113_((String)""));
            }
            list.add(Component.m_237110_((String)"tooltip.enchlib.max_lvl", (Object[])new Object[]{Component.m_237115_((String)("enchantment.level." + libSlot.maxLvl))}).m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237110_((String)"tooltip.enchlib.points", (Object[])new Object[]{EnchLibraryScreen.format(libSlot.points), EnchLibraryScreen.format(((EnchLibraryContainer)this.f_97732_).getPointCap())}).m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)""));
            ItemStack outSlot = ((EnchLibraryContainer)this.f_97732_).ioInv.m_8020_(1);
            int current = EnchantmentHelper.m_44831_((ItemStack)outSlot).getOrDefault(libSlot.ench, 0);
            boolean shift = Screen.m_96638_();
            int n = targetLevel = shift ? Math.min(libSlot.maxLvl, 1 + (int)(Math.log(libSlot.points + EnchLibraryTile.levelToPoints(current)) / Math.log(2.0))) : current + 1;
            if (targetLevel == current) {
                ++targetLevel;
            }
            int cost = EnchLibraryTile.levelToPoints(targetLevel) - EnchLibraryTile.levelToPoints(current);
            if (targetLevel > libSlot.maxLvl) {
                list.add(Component.m_237115_((String)"tooltip.enchlib.unavailable").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            } else {
                list.add(Component.m_237110_((String)"tooltip.enchlib.extracting", (Object[])new Object[]{Component.m_237115_((String)("enchantment.level." + targetLevel))}).m_130940_(ChatFormatting.BLUE));
                list.add(Component.m_237110_((String)"tooltip.enchlib.cost", (Object[])new Object[]{cost}).m_130940_(cost > libSlot.points ? ChatFormatting.RED : ChatFormatting.GOLD));
            }
            gfx.renderComponentTooltip(this.f_96547_, list, this.getGuiLeft() - 16 - list.stream().map(arg_0 -> ((Font)this.f_96547_).m_92852_(arg_0)).max(Integer::compare).get(), mouseY, ItemStack.f_41583_);
        }
    }

    protected void m_7286_(GuiGraphics gfx, float partial, int mouseX, int mouseY) {
        int left = this.f_97735_;
        int top = this.f_97736_;
        gfx.m_280218_(TEXTURES, left, top, 0, 0, this.f_97726_, this.f_97727_);
        int scrollbarPos = (int)(118.0f * this.scrollOffs);
        gfx.m_280218_(TEXTURES, left + 75, top + 14 + scrollbarPos, 244, this.isScrollBarActive() ? 0 : 15, 12, 15);
        for (int idx = this.startIndex; idx < this.startIndex + 7 && idx < this.data.size(); ++idx) {
            this.renderEntry(gfx, this.data.get(idx), this.f_97735_ + 8, this.f_97736_ + 14 + 19 * (idx - this.startIndex), mouseX, mouseY);
        }
        gfx.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"tooltip.enchlib.nfilt"), this.getGuiLeft() + 91, this.getGuiTop() + 20, 0x404040, false);
        gfx.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"tooltip.enchlib.ifilt"), this.getGuiLeft() + 91, this.getGuiTop() + 50, 0x404040, false);
    }

    private void renderEntry(GuiGraphics gfx, LibrarySlot data, int x, int y, int mouseX, int mouseY) {
        boolean hover = this.m_6774_(x - this.f_97735_, y - this.f_97736_, 64, 17, mouseX, mouseY);
        gfx.m_280218_(TEXTURES, x, y, 178, hover ? 19 : 0, 64, 19);
        int progress = (int)Math.round(62.0 * Math.sqrt(data.points) / (double)((float)Math.sqrt(((EnchLibraryContainer)this.f_97732_).getPointCap())));
        gfx.m_280218_(TEXTURES, x + 1, y + 12, 179, 38, progress, 5);
        PoseStack stack = gfx.m_280168_();
        stack.m_85836_();
        MutableComponent txt = Component.m_237115_((String)data.ench.m_44704_());
        float scale = 1.0f;
        if (this.f_96547_.m_92852_((FormattedText)txt) > 60) {
            scale = 60.0f / (float)this.f_96547_.m_92852_((FormattedText)txt);
        }
        stack.m_85841_(scale, scale, 1.0f);
        gfx.m_280614_(this.f_96547_, (Component)txt, (int)((float)(x + 2) / scale), (int)((float)(y + 2) / scale), 0xFFFF80, false);
        stack.m_85849_();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        int left = this.f_97735_ + 52;
        int top = this.f_97736_ + 14;
        LibrarySlot libSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (libSlot != null) {
            int id = ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((Object)libSlot.ench);
            if (Screen.m_96638_()) {
                id |= Integer.MIN_VALUE;
            }
            ((EnchLibraryContainer)this.f_97732_).onButtonClick(id);
            Placebo.CHANNEL.sendToServer((Object)new ButtonClickMessage(id));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
        }
        left = this.f_97735_ + 75;
        top = this.f_97736_ + 9;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 131)) {
            this.scrolling = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 131;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 7;
    }

    protected int getOffscreenRows() {
        return this.data.size() - 7;
    }

    private void containerChanged() {
        this.data.clear();
        List<Object2IntMap.Entry<Enchantment>> entries = this.filter(((EnchLibraryContainer)this.f_97732_).getPointsForDisplay());
        for (Object2IntMap.Entry<Enchantment> e : entries) {
            this.data.add(new LibrarySlot((Enchantment)e.getKey(), e.getIntValue(), ((EnchLibraryContainer)this.f_97732_).getMaxLevel((Enchantment)e.getKey())));
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        Collections.sort(this.data, (a, b) -> I18n.m_118938_((String)a.ench.m_44704_(), (Object[])new Object[0]).compareTo(I18n.m_118938_((String)b.ench.m_44704_(), (Object[])new Object[0])));
    }

    private List<Object2IntMap.Entry<Enchantment>> filter(List<Object2IntMap.Entry<Enchantment>> list) {
        return list.stream().filter(this::isAllowedByItem).filter(this::isAllowedBySearch).toList();
    }

    private boolean isAllowedByItem(Object2IntMap.Entry<Enchantment> e) {
        ItemStack stack = ((EnchLibraryContainer)this.f_97732_).ioInv.m_8020_(2);
        return stack.m_41619_() || ((Enchantment)e.getKey()).m_6081_(stack);
    }

    private boolean isAllowedBySearch(Object2IntMap.Entry<Enchantment> e) {
        String name = I18n.m_118938_((String)((Enchantment)e.getKey()).m_44704_(), (Object[])new Object[0]).toLowerCase(Locale.ROOT);
        String search = this.filter == null ? "" : this.filter.m_94155_().trim().toLowerCase(Locale.ROOT);
        return Strings.isNullOrEmpty((String)search) || ChatFormatting.m_126649_((String)name).contains(search);
    }

    @Nullable
    public LibrarySlot getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 7; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.m_6774_(8, 14 + 19 * i, 64, 17, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    private record LibrarySlot(Enchantment ench, int points, int maxLvl) {
    }
}

