/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.village;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.village.VillageModuleClient;
import dev.shadowsoffire.apotheosis.village.fletching.ApothFletchingBlock;
import dev.shadowsoffire.apotheosis.village.fletching.FletchingContainer;
import dev.shadowsoffire.apotheosis.village.fletching.FletchingRecipe;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.BroadheadArrowEntity;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.BroadheadArrowItem;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.ExplosiveArrowEntity;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.ExplosiveArrowItem;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.IApothArrowItem;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.MiningArrowEntity;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.MiningArrowItem;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.ObsidianArrowEntity;
import dev.shadowsoffire.apotheosis.village.fletching.arrows.ObsidianArrowItem;
import dev.shadowsoffire.apotheosis.village.wanderer.WandererReplacements;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.menu.MenuUtil;
import dev.shadowsoffire.placebo.registry.RegistryEvent;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import dev.shadowsoffire.placebo.util.PlaceboUtil;
import java.io.File;
import java.util.function.Supplier;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillageModule {
    public static final RecipeSerializer<FletchingRecipe> FLETCHING_SERIALIZER = new FletchingRecipe.Serializer();
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Village");
    public static Configuration config;
    public static Level.ExplosionInteraction expArrowMode;

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        config = new Configuration(new File(Apotheosis.configDir, "village.cfg"));
        config.setTitle("Apotheosis Village Module Configuration");
        WandererReplacements.load(config);
        boolean blockDmg = config.getBoolean("Explosive Arrow Block Damage", "arrows", true, "If explosive arrows can break blocks.\nServer-authoritative.");
        Level.ExplosionInteraction explosionInteraction = expArrowMode = blockDmg ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE;
        if (config.hasChanged()) {
            config.save();
        }
        e.enqueueWork(() -> {
            for (final Item i : ForgeRegistries.ITEMS) {
                if (!(i instanceof IApothArrowItem)) continue;
                DispenserBlock.m_52672_((ItemLike)i, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                    protected Projectile m_6895_(Level world, Position pos, ItemStack stack) {
                        return ((IApothArrowItem)i).fromDispenser(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public void setup(FMLClientSetupEvent e) {
        e.enqueueWork(VillageModuleClient::init);
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register(FLETCHING_SERIALIZER, FletchingRecipe.Serializer.NAME);
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        PlaceboUtil.registerOverride((Block)Blocks.f_50622_, (Block)new ApothFletchingBlock(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll(new Object[]{new ObsidianArrowItem(new Item.Properties()), "obsidian_arrow", new BroadheadArrowItem(new Item.Properties()), "broadhead_arrow", new ExplosiveArrowItem(new Item.Properties()), "explosive_arrow", new MiningArrowItem(() -> Items.f_42385_, MiningArrowEntity.Type.IRON), "iron_mining_arrow", new MiningArrowItem(() -> Items.f_42390_, MiningArrowEntity.Type.DIAMOND), "diamond_mining_arrow"});
        TabFillingRegistry.register((ResourceKey)CreativeModeTabs.f_256797_, (Supplier[])new Supplier[]{Apoth.Items.OBSIDIAN_ARROW, Apoth.Items.BROADHEAD_ARROW, Apoth.Items.EXPLOSIVE_ARROW, Apoth.Items.IRON_MINING_ARROW, Apoth.Items.DIAMOND_MINING_ARROW});
    }

    @SubscribeEvent
    public void entities(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().register((Object)EntityType.Builder.m_20704_(ObsidianArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).m_20699_(0.5f, 0.5f).setCustomClientFactory((se, w) -> new ObsidianArrowEntity((Level)w)).m_20712_("obsidian_arrow"), "obsidian_arrow");
        e.getRegistry().register((Object)EntityType.Builder.m_20704_(BroadheadArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).m_20699_(0.5f, 0.5f).setCustomClientFactory((se, w) -> new BroadheadArrowEntity((Level)w)).m_20712_("broadhead_arrow"), "broadhead_arrow");
        e.getRegistry().register((Object)EntityType.Builder.m_20704_(ExplosiveArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).m_20699_(0.5f, 0.5f).setCustomClientFactory((se, w) -> new ExplosiveArrowEntity((Level)w)).m_20712_("explosive_arrow"), "explosive_arrow");
        e.getRegistry().register((Object)EntityType.Builder.m_20704_(MiningArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(4).setUpdateInterval(20).m_20699_(0.5f, 0.5f).setCustomClientFactory((se, w) -> new MiningArrowEntity((Level)w)).m_20712_("mining_arrow"), "mining_arrow");
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((Object)MenuUtil.type(FletchingContainer::new), "fletching");
    }

    static {
        expArrowMode = Level.ExplosionInteraction.BLOCK;
    }
}

