/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.config.gui.modules;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.gui.modules.ModulesScreen;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.CoordsModule;
import me.cominixo.betterf3.modules.FpsModule;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ModuleListWidget
extends ObjectSelectionList<ModuleEntry> {
    final ModulesScreen modulesScreen;
    final List<ModuleEntry> moduleEntries = new ArrayList<ModuleEntry>();

    public ModuleListWidget(ModulesScreen modulesScreen, Minecraft client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, height, top, bottom, entryHeight);
        this.modulesScreen = modulesScreen;
    }

    protected int scrollbarPositionX() {
        return super.m_5756_() + 30;
    }

    public int rowWidth() {
        return super.m_5759_() + 85;
    }

    public ModuleEntry entry(int index) {
        return this.moduleEntries.get(index);
    }

    public void modules(List<BaseModule> modules) {
        this.moduleEntries.clear();
        this.m_93516_();
        for (BaseModule module : modules) {
            this.addModule(module);
        }
    }

    public void updateModules() {
        this.m_93516_();
        this.moduleEntries.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
    }

    public void addModule(BaseModule module) {
        ModuleEntry entry = new ModuleEntry(this.modulesScreen, module);
        this.moduleEntries.add(entry);
        this.m_7085_((AbstractSelectionList.Entry)entry);
    }

    public void removeModule(int index) {
        ModuleEntry entry = this.moduleEntries.get(index);
        this.moduleEntries.remove((Object)entry);
        this.m_93502_((AbstractSelectionList.Entry)entry);
        this.modulesScreen.updateButtons();
        if (this.m_93517_() > (double)this.m_93518_()) {
            this.m_93410_(this.m_93518_());
        }
    }

    public class ModuleEntry
    extends ObjectSelectionList.Entry<ModuleEntry> {
        private final ModulesScreen modulesScreen;
        private final Minecraft client;
        public final BaseModule module;

        protected ModuleEntry(ModulesScreen modulesScreen, BaseModule module) {
            this.modulesScreen = modulesScreen;
            this.module = module;
            this.client = Minecraft.m_91087_();
        }

        public Component m_142172_() {
            return Component.m_130674_((String)this.module.toString());
        }

        public void m_6311_(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Object exampleText;
            context.m_280056_(this.client.f_91062_, this.module.toString(), x + 35, y + 1, 0xFFFFFF, true);
            BaseModule baseModule = this.module;
            if (baseModule instanceof CoordsModule) {
                CoordsModule coordsModule = (CoordsModule)baseModule;
                exampleText = Utils.styledText("X", coordsModule.colorX).m_7220_((Component)Utils.styledText("Y", coordsModule.colorY)).m_7220_((Component)Utils.styledText("Z", coordsModule.colorZ)).m_7220_((Component)Utils.styledText(": ", coordsModule.nameColor)).m_7220_((Component)Utils.styledText("100 ", coordsModule.colorX).m_7220_((Component)Utils.styledText("200 ", coordsModule.colorY)).m_7220_((Component)Utils.styledText("300", coordsModule.colorZ)));
            } else {
                baseModule = this.module;
                if (baseModule instanceof FpsModule) {
                    FpsModule fpsModule = (FpsModule)baseModule;
                    exampleText = Utils.styledText("60 fps  ", fpsModule.colorHigh).m_7220_((Component)Utils.styledText("40 fps  ", fpsModule.colorMed)).m_7220_((Component)Utils.styledText("10 fps", fpsModule.colorLow));
                } else {
                    exampleText = this.module.nameColor != null && this.module.valueColor != null ? Utils.styledText("Name: ", this.module.nameColor).m_7220_((Component)Utils.styledText("Value", this.module.valueColor)) : Component.m_130674_((String)"");
                }
            }
            context.m_280614_(this.client.f_91062_, exampleText, x + 43, y + 13, 0xFFFFFF, true);
            if (((Boolean)this.client.f_91066_.m_231828_().m_231551_()).booleanValue() || hovered) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("textures/gui/server_selection.png"));
                context.m_280509_(x, y, x + 32, y + 32, -1601138544);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int v = mouseX - x;
                int w = mouseY - y;
                if (index > 0) {
                    if (v < 16 && w < 16) {
                        context.m_280218_(new ResourceLocation("textures/gui/server_selection.png"), x, y, 96, 32, 32, 32);
                    } else {
                        context.m_280218_(new ResourceLocation("textures/gui/server_selection.png"), x, y, 96, 0, 32, 32);
                    }
                }
                if (index < ModuleListWidget.this.moduleEntries.size() - 1) {
                    if (v < 16 && w > 16) {
                        context.m_280218_(new ResourceLocation("textures/gui/server_selection.png"), x, y, 64, 32, 32, 32);
                    } else {
                        context.m_280218_(new ResourceLocation("textures/gui/server_selection.png"), x, y, 64, 0, 32, 32);
                    }
                }
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)this.modulesScreen.modulesListWidget.m_5747_();
            double e = mouseY - (double)ModuleListWidget.this.m_7610_(ModuleListWidget.this.m_6702_().indexOf((Object)this));
            if (d <= 32.0) {
                int i = this.modulesScreen.modulesListWidget.m_6702_().indexOf((Object)this);
                if (d < 16.0 && e < 16.0 && i > 0) {
                    this.swapEntries(i, i - 1);
                    return true;
                }
                if (d < 16.0 && e > 16.0 && i < ModuleListWidget.this.moduleEntries.size() - 1) {
                    this.swapEntries(i, i + 1);
                    return true;
                }
            }
            this.modulesScreen.select(this);
            return false;
        }

        private void swapEntries(int i, int j) {
            ModuleEntry temp = ModuleListWidget.this.moduleEntries.get(i);
            ModuleListWidget.this.moduleEntries.set(i, ModuleListWidget.this.moduleEntries.get(j));
            ModuleListWidget.this.moduleEntries.set(j, temp);
            this.modulesScreen.modulesListWidget.m_6987_((AbstractSelectionList.Entry)temp);
            this.modulesScreen.updateButtons();
            this.modulesScreen.modulesListWidget.updateModules();
        }
    }
}

