/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.api.mana.TinyPlanetExcempt;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.lib.BotaniaTags;

public class LaputaShardItem
extends Item
implements LensEffectItem,
TinyPlanetExcempt,
CustomCreativeTabContents {
    private static final String TAG_STATE = "_state";
    private static final String TAG_TILE = "_tile";
    private static final String TAG_X = "_x";
    private static final String TAG_Y = "_y";
    private static final String TAG_Y_START = "_yStart";
    private static final String TAG_Z = "_z";
    private static final String TAG_POINTY = "_pointy";
    private static final String TAG_HEIGHTSCALE = "_heightscale";
    private static final String TAG_ITERATION_I = "iterationI";
    private static final String TAG_ITERATION_J = "iterationJ";
    private static final String TAG_ITERATION_K = "iterationK";
    public static final String TAG_LEVEL = "level";
    private static final int BASE_RANGE = 14;
    private static final int BASE_OFFSET = 42;

    public LaputaShardItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        for (int i = 0; i <= 20; i += 5) {
            ItemStack s = new ItemStack((ItemLike)this);
            if (i != 0) {
                s.m_41784_().m_128405_(TAG_LEVEL, i - 1);
            }
            output.m_246342_(s);
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        int level = LaputaShardItem.getShardLevel(stack);
        MutableComponent levelLoc = Component.m_237115_((String)("botania.roman" + (level + 1)));
        list.add((Component)Component.m_237110_((String)"botaniamisc.shardLevel", (Object[])new Object[]{levelLoc}).m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237110_((String)"botaniamisc.shardRange", (Object[])new Object[]{this.getRange(stack)}).m_130940_(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (pos.m_123342_() < world.m_151558_() - 42 && !world.m_6042_().f_63856_()) {
            if (!world.f_46443_) {
                world.m_5594_(null, pos, BotaniaSounds.laputaStart, SoundSource.BLOCKS, 1.0f + world.f_46441_.m_188501_(), world.f_46441_.m_188501_() * 0.7f + 1.3f);
                ItemStack stack = ctx.m_43722_();
                this.spawnFirstBurst(world, pos, stack);
                if (ctx.m_43723_() != null) {
                    UseItemSuccessTrigger.INSTANCE.trigger((ServerPlayer)ctx.m_43723_(), stack, (ServerLevel)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                }
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private int getRange(ItemStack shard) {
        return 14 + LaputaShardItem.getShardLevel(shard);
    }

    protected void spawnFirstBurst(Level world, BlockPos pos, ItemStack shard) {
        int range = this.getRange(shard);
        boolean pointy = world.f_46441_.m_188500_() < 0.25;
        double heightscale = (world.f_46441_.m_188500_() + 0.5) * (14.0 / (double)range);
        this.spawnNextBurst(world, pos, shard, pointy, heightscale);
    }

    protected void spawnNextBurst(Level world, BlockPos pos, ItemStack lens) {
        boolean pointy = ItemNBTHelper.getBoolean(lens, TAG_POINTY, false);
        double heightscale = ItemNBTHelper.getDouble(lens, TAG_HEIGHTSCALE, 1.0);
        this.spawnNextBurst(world, pos, lens, pointy, heightscale);
    }

    private static boolean canMove(BlockState state, Level world, BlockPos pos) {
        FluidState fluidState = state.m_60819_();
        boolean isFlowingFluid = !fluidState.m_76178_() && !fluidState.m_76170_();
        Block block = state.m_60734_();
        return !state.m_60795_() && !isFlowingFluid && !(block instanceof FallingBlock) && !state.m_204336_(BotaniaTags.Blocks.LAPUTA_IMMOBILE) && state.m_60800_((BlockGetter)world, pos) != -1.0f;
    }

    private void spawnNextBurst(Level world, BlockPos pos, ItemStack shard, boolean pointy, double heightscale) {
        int range = this.getRange(shard);
        int i = ItemNBTHelper.getInt(shard, TAG_ITERATION_I, 0);
        int j = ItemNBTHelper.getInt(shard, TAG_ITERATION_J, 35);
        int k = ItemNBTHelper.getInt(shard, TAG_ITERATION_K, 0);
        if (j <= -28) {
            j = 35;
        }
        if (k >= range * 2 + 1) {
            k = 0;
        }
        while (i < range * 2 + 1) {
            while (j > -28) {
                while (k < range * 2 + 1) {
                    BlockPos pos_ = pos.m_7918_(-range + i, -14 + j, -range + k);
                    if (this.inRange(pos_, pos, range, heightscale, pointy)) {
                        BlockState state = world.m_8055_(pos_);
                        Block block = state.m_60734_();
                        if (LaputaShardItem.canMove(state, world, pos_)) {
                            BlockEntity tile = world.m_7702_(pos_);
                            CompoundTag cmp = new CompoundTag();
                            if (tile != null) {
                                cmp = tile.m_187480_();
                                BlockEntity newTile = ((EntityBlock)block).m_142194_(pos_, state);
                                world.m_151523_(newTile);
                            }
                            if (!world.m_7471_(pos_, false)) {
                                if (tile != null) {
                                    world.m_151523_(tile);
                                }
                            } else {
                                world.m_46796_(2001, pos_, Block.m_49956_((BlockState)state));
                                ItemStack copyLens = new ItemStack((ItemLike)this);
                                copyLens.m_41784_().m_128405_(TAG_LEVEL, LaputaShardItem.getShardLevel(shard));
                                copyLens.m_41783_().m_128365_(TAG_STATE, (Tag)NbtUtils.m_129202_((BlockState)state));
                                ItemNBTHelper.setCompound(copyLens, TAG_TILE, cmp);
                                ItemNBTHelper.setInt(copyLens, TAG_X, pos.m_123341_());
                                ItemNBTHelper.setInt(copyLens, TAG_Y, pos.m_123342_());
                                ItemNBTHelper.setInt(copyLens, TAG_Y_START, pos_.m_123342_());
                                ItemNBTHelper.setInt(copyLens, TAG_Z, pos.m_123343_());
                                ItemNBTHelper.setBoolean(copyLens, TAG_POINTY, pointy);
                                ItemNBTHelper.setDouble(copyLens, TAG_HEIGHTSCALE, heightscale);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_I, i);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_J, j);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_K, k);
                                ManaBurstEntity burst = this.getBurst(world, pos_, copyLens);
                                world.m_7967_((Entity)burst);
                                return;
                            }
                        }
                    }
                    ++k;
                }
                k = 0;
                --j;
            }
            j = 35;
            ++i;
        }
    }

    public static int getShardLevel(ItemStack shard) {
        if (!shard.m_41782_()) {
            return 0;
        }
        return shard.m_41784_().m_128451_(TAG_LEVEL);
    }

    private boolean inRange(BlockPos pos, BlockPos srcPos, int range, double heightscale, boolean pointy) {
        if (pos.m_123342_() >= srcPos.m_123342_()) {
            return MathHelper.pointDistanceSpace(pos.m_123341_(), 0.0, pos.m_123343_(), srcPos.m_123341_(), 0.0, srcPos.m_123343_()) < (float)range;
        }
        if (!pointy) {
            return MathHelper.pointDistanceSpace(pos.m_123341_(), (double)pos.m_123342_() / heightscale, pos.m_123343_(), srcPos.m_123341_(), (double)srcPos.m_123342_() / heightscale, srcPos.m_123343_()) < (float)range;
        }
        return (double)MathHelper.pointDistanceSpace(pos.m_123341_(), 0.0, pos.m_123343_(), srcPos.m_123341_(), 0.0, srcPos.m_123343_()) < (double)range - (double)(srcPos.m_123342_() - pos.m_123342_()) / heightscale;
    }

    public ManaBurstEntity getBurst(Level world, BlockPos pos, ItemStack stack) {
        ManaBurstEntity burst = (ManaBurstEntity)BotaniaEntities.MANA_BURST.m_20615_(world);
        burst.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        burst.setColor(60159);
        burst.setMana(1);
        burst.setStartingMana(1);
        burst.setMinManaLoss(0);
        burst.setManaLossPerTick(0.0f);
        burst.setGravity(0.0f);
        burst.m_20334_(0.0, 0.5, 0.0);
        burst.setSourceLens(stack);
        return burst;
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props, Level level) {
    }

    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        return false;
    }

    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        double speed = 0.35;
        int targetDistance = 42;
        ThrowableProjectile entity = burst.entity();
        if (!entity.m_9236_().f_46443_) {
            entity.m_20334_(0.0, speed, 0.0);
            int spawnTicks = 2;
            int placeTicks = Mth.m_14107_((double)((double)targetDistance / speed));
            ItemStack lens = burst.getSourceLens();
            if (burst.getTicksExisted() == 2) {
                int x = ItemNBTHelper.getInt(lens, TAG_X, 0);
                int y = ItemNBTHelper.getInt(lens, TAG_Y, Integer.MIN_VALUE);
                int z = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                if (y != Integer.MIN_VALUE) {
                    this.spawnNextBurst(entity.m_9236_(), new BlockPos(x, y, z), lens);
                }
            } else if (burst.getTicksExisted() == placeTicks) {
                int x = Mth.m_14107_((double)entity.m_20185_());
                int y = ItemNBTHelper.getInt(lens, TAG_Y_START, -1) + targetDistance;
                int z = Mth.m_14107_((double)entity.m_20189_());
                BlockPos pos = new BlockPos(x, y, z);
                BlockState placeState = Blocks.f_50016_.m_49966_();
                if (lens.m_41782_() && lens.m_41783_().m_128441_(TAG_STATE)) {
                    placeState = NbtUtils.m_247651_((HolderGetter)entity.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)lens.m_41783_().m_128469_(TAG_STATE));
                }
                if (entity.m_9236_().m_6042_().f_63857_() && placeState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    placeState = (BlockState)placeState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                }
                if (entity.m_9236_().m_8055_(pos).m_247087_()) {
                    BlockEntity tile = null;
                    CompoundTag tilecmp = ItemNBTHelper.getCompound(lens, TAG_TILE, false);
                    if (tilecmp.m_128441_("id")) {
                        tile = BlockEntity.m_155241_((BlockPos)pos, (BlockState)placeState, (CompoundTag)tilecmp);
                    }
                    entity.m_9236_().m_46597_(pos, placeState);
                    entity.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)placeState));
                    if (tile != null) {
                        entity.m_9236_().m_151523_(tile);
                    }
                } else {
                    int ox = ItemNBTHelper.getInt(lens, TAG_X, 0);
                    int oy = ItemNBTHelper.getInt(lens, TAG_Y_START, -1);
                    int oz = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                    Block.m_49950_((BlockState)placeState, (Level)entity.m_9236_(), (BlockPos)new BlockPos(ox, oy, oz));
                }
                entity.m_146870_();
            }
        }
    }

    @Override
    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        ItemStack lens = burst.getSourceLens();
        BlockState state = NbtUtils.m_247651_((HolderGetter)entity.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)lens.m_41784_().m_128469_(TAG_STATE));
        entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_20184_().m_7096_(), entity.m_20184_().m_7098_(), entity.m_20184_().m_7094_());
        return true;
    }

    @Override
    public boolean shouldPull(ItemStack stack) {
        return false;
    }
}

