/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.StringObfuscator;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;

public class FlugelTiaraItem
extends BaubleItem
implements CustomCreativeTabContents {
    private static final ResourceLocation textureHud = new ResourceLocation("botania:textures/gui/hud_icons.png");
    public static final ResourceLocation textureHalo = new ResourceLocation("botania:textures/misc/halo.png");
    private static final String TAG_VARIANT = "variant";
    private static final String TAG_FLYING = "flying";
    private static final String TAG_GLIDING = "gliding";
    private static final String TAG_TIME_LEFT = "timeLeft";
    private static final String TAG_INFINITE_FLIGHT = "infiniteFlight";
    private static final String TAG_DASH_COOLDOWN = "dashCooldown";
    private static final String TAG_IS_SPRINTING = "isSprinting";
    private static final String TAG_BOOST_PENDING = "boostPending";
    private static final List<String> playersWithFlight = Collections.synchronizedList(new ArrayList());
    private static final int COST = 35;
    private static final int COST_OVERKILL = 105;
    private static final int MAX_FLY_TIME = 1200;
    private static final int SUBTYPES = 8;
    public static final int WING_TYPES = 9;
    private static final String SUPER_AWESOME_HASH = "4D0F274C5E3001C95640B5E88A821422C8B1E132264492C043A3D746B705C025";

    public FlugelTiaraItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemNBTHelper.setInt(stack, TAG_VARIANT, i);
            output.m_246342_(stack);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237115_((String)("botania.wings" + FlugelTiaraItem.getVariant(stack))));
    }

    public static void updatePlayerFlyStatus(Player player) {
        ItemStack tiara = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, (LivingEntity)player);
        int left = ItemNBTHelper.getInt(tiara, TAG_TIME_LEFT, 1200);
        if (playersWithFlight.contains(FlugelTiaraItem.playerStr(player))) {
            if (FlugelTiaraItem.shouldPlayerHaveFlight(player)) {
                player.m_150110_().f_35936_ = true;
                if (player.m_150110_().f_35935_) {
                    if (!player.m_9236_().f_46443_) {
                        if (!player.m_7500_() && !player.m_5833_()) {
                            ManaItemHandler.instance().requestManaExact(tiara, player, FlugelTiaraItem.getCost(tiara, left), true);
                        }
                    } else if (Math.abs(player.m_20184_().m_7096_()) > 0.1 || Math.abs(player.m_20184_().m_7094_()) > 0.1) {
                        double x = player.m_20185_() - 0.5;
                        double y = player.m_20186_() - 0.5;
                        double z = player.m_20189_() - 0.5;
                        float r = 1.0f;
                        float g = 1.0f;
                        float b = 1.0f;
                        int variant = FlugelTiaraItem.getVariant(tiara);
                        switch (variant) {
                            case 2: {
                                r = 0.1f;
                                g = 0.1f;
                                b = 0.1f;
                                break;
                            }
                            case 3: {
                                r = 0.0f;
                                g = 0.6f;
                                break;
                            }
                            case 4: {
                                g = 0.3f;
                                b = 0.3f;
                                break;
                            }
                            case 5: {
                                r = 0.6f;
                                g = 0.0f;
                                b = 0.6f;
                                break;
                            }
                            case 6: {
                                r = 0.4f;
                                g = 0.0f;
                                b = 0.0f;
                                break;
                            }
                            case 7: {
                                r = 0.2f;
                                g = 0.6f;
                                b = 0.2f;
                                break;
                            }
                            case 8: {
                                r = 0.85f;
                                g = 0.85f;
                                b = 0.0f;
                                break;
                            }
                            case 9: {
                                r = 0.0f;
                                b = 0.0f;
                            }
                        }
                        for (int i = 0; i < 2; ++i) {
                            SparkleParticleData data = SparkleParticleData.sparkle(2.0f * (float)Math.random(), r, g, b, 20);
                            player.m_9236_().m_7106_((ParticleOptions)data, x + Math.random() * (double)player.m_20205_(), y + Math.random() * 0.4, z + Math.random() * (double)player.m_20205_(), 0.0, 0.0, 0.0);
                        }
                    }
                }
            } else {
                if (!player.m_5833_() && !player.m_150110_().f_35937_) {
                    player.m_150110_().f_35936_ = false;
                    player.m_150110_().f_35935_ = false;
                    player.m_150110_().f_35934_ = false;
                }
                playersWithFlight.remove(FlugelTiaraItem.playerStr(player));
            }
        } else if (FlugelTiaraItem.shouldPlayerHaveFlight(player)) {
            playersWithFlight.add(FlugelTiaraItem.playerStr(player));
            player.m_150110_().f_35936_ = true;
        }
    }

    public static void playerLoggedOut(ServerPlayer player) {
        String username = player.m_36316_().getName();
        playersWithFlight.remove(username + ":false");
        playersWithFlight.remove(username + ":true");
    }

    private static String playerStr(Player player) {
        return player.m_36316_().getName() + ":" + player.m_9236_().f_46443_;
    }

    private static boolean shouldPlayerHaveFlight(Player player) {
        ItemStack armor = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, (LivingEntity)player);
        if (!armor.m_41619_()) {
            int left = ItemNBTHelper.getInt(armor, TAG_TIME_LEFT, 1200);
            boolean flying = ItemNBTHelper.getBoolean(armor, TAG_FLYING, false);
            return (left > (flying ? 0 : 120) || player.m_150109_().m_36063_(new ItemStack((ItemLike)BotaniaItems.flugelEye))) && ManaItemHandler.instance().requestManaExact(armor, player, FlugelTiaraItem.getCost(armor, left), false);
        }
        return false;
    }

    public static int getCost(ItemStack stack, int timeLeft) {
        return timeLeft <= 0 ? 105 : 35;
    }

    @Override
    public void onEquipped(ItemStack stack, LivingEntity living) {
        super.onEquipped(stack, living);
        int variant = FlugelTiaraItem.getVariant(stack);
        if (variant != 9 && StringObfuscator.matchesHash(stack.m_41786_().getString(), SUPER_AWESOME_HASH)) {
            ItemNBTHelper.setInt(stack, TAG_VARIANT, 9);
            stack.m_41787_();
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        if (living instanceof Player) {
            int time;
            Player player = (Player)living;
            boolean flying = player.m_150110_().f_35935_;
            boolean wasSprting = ItemNBTHelper.getBoolean(stack, TAG_IS_SPRINTING, false);
            boolean isSprinting = player.m_20142_();
            if (isSprinting != wasSprting) {
                ItemNBTHelper.setBoolean(stack, TAG_IS_SPRINTING, isSprinting);
            }
            int newTime = time = ItemNBTHelper.getInt(stack, TAG_TIME_LEFT, 1200);
            Vec3 look = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
            if (flying) {
                if (!(time <= 0 || player.m_5833_() || player.m_7500_() || ItemNBTHelper.getBoolean(stack, TAG_INFINITE_FLIGHT, false))) {
                    --newTime;
                }
                int maxCd = 80;
                int cooldown = ItemNBTHelper.getInt(stack, TAG_DASH_COOLDOWN, 0);
                if (!wasSprting && isSprinting && cooldown == 0) {
                    player.m_20256_(player.m_20184_().m_82520_(look.f_82479_, 0.0, look.f_82481_));
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.dash, SoundSource.PLAYERS, 1.0f, 1.0f);
                    ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, 80);
                    ItemNBTHelper.setBoolean(stack, TAG_BOOST_PENDING, true);
                } else if (cooldown > 0) {
                    if (ItemNBTHelper.getBoolean(stack, TAG_BOOST_PENDING, false)) {
                        living.m_19920_(5.0f, new Vec3(0.0, 0.0, 1.0));
                        ItemNBTHelper.removeEntry(stack, TAG_BOOST_PENDING);
                    }
                    ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, cooldown - 2);
                }
            } else {
                boolean doGlide;
                boolean wasGliding = ItemNBTHelper.getBoolean(stack, TAG_GLIDING, false);
                boolean bl = doGlide = living.m_6144_() && !living.m_20096_() && (living.m_20184_().m_7098_() < (double)-0.7f || wasGliding);
                if (time < 1200 && living.f_19797_ % (doGlide ? 6 : 2) == 0) {
                    ++newTime;
                }
                if (doGlide) {
                    float mul = 0.6f;
                    living.m_20334_(look.f_82479_ * (double)mul, Math.max((double)-0.15f, living.m_20184_().m_7098_()), look.f_82481_ * (double)mul);
                    living.f_19789_ = 2.0f;
                }
                ItemNBTHelper.setBoolean(stack, TAG_GLIDING, doGlide);
            }
            ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
            if (newTime != time) {
                ItemNBTHelper.setInt(stack, TAG_TIME_LEFT, newTime);
            }
        }
    }

    @Override
    public boolean hasRender(ItemStack stack, LivingEntity living) {
        return super.hasRender(stack, living) && living instanceof Player;
    }

    public static int getVariant(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_VARIANT, 0);
    }

    public static class Renderer
    implements AccessoryRenderer {
        private static void renderBasic(HumanoidModel<?> bipedModel, BakedModel model, ItemStack stack, PoseStack ms, MultiBufferSource buffers, int light, float flap) {
            ms.m_85836_();
            bipedModel.f_102810_.m_104299_(ms);
            ms.m_85837_(0.0, 0.5, 0.2);
            for (int i = 0; i < 2; ++i) {
                ms.m_85836_();
                ms.m_252781_(VecHelper.rotateY(i == 0 ? flap : 180.0f - flap));
                ms.m_252880_(-1.0f, 0.0f, 0.0f);
                ms.m_252781_(VecHelper.rotateZ(-60.0f));
                ms.m_85841_(1.5f, -1.5f, -1.5f);
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, ms, buffers, light, OverlayTexture.f_118083_, model);
                ms.m_85849_();
            }
            ms.m_85849_();
        }

        private static void renderSephiroth(HumanoidModel<?> bipedModel, BakedModel model, ItemStack stack, PoseStack ms, MultiBufferSource buffers, int light, float flap) {
            ms.m_85836_();
            bipedModel.f_102810_.m_104299_(ms);
            ms.m_85837_(0.0, 0.5, 0.2);
            ms.m_252781_(VecHelper.rotateY(flap));
            ms.m_85837_(-1.1, 0.0, 0.0);
            ms.m_252781_(VecHelper.rotateZ(-60.0f));
            ms.m_85841_(1.6f, -1.6f, -1.6f);
            Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, ms, buffers, light, OverlayTexture.f_118083_, model);
            ms.m_85849_();
        }

        private static void renderCirno(HumanoidModel<?> bipedModel, BakedModel model, ItemStack stack, PoseStack ms, MultiBufferSource buffers, int light) {
            ms.m_85836_();
            bipedModel.f_102810_.m_104299_(ms);
            ms.m_85837_(-0.8, 0.15, 0.25);
            for (int i = 0; i < 2; ++i) {
                ms.m_85836_();
                if (i == 1) {
                    ms.m_252781_(VecHelper.rotateY(180.0f));
                    ms.m_85837_(-1.6, 0.0, 0.0);
                }
                ms.m_85841_(1.6f, -1.6f, -1.6f);
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, ms, buffers, light, OverlayTexture.f_118083_, model);
                ms.m_85849_();
            }
            ms.m_85849_();
        }

        private static void renderPhoenix(HumanoidModel<?> bipedModel, BakedModel model, ItemStack stack, PoseStack ms, MultiBufferSource buffers, float flap) {
            ms.m_85836_();
            bipedModel.f_102810_.m_104299_(ms);
            ms.m_85837_(0.0, -0.2, 0.2);
            for (int i = 0; i < 2; ++i) {
                ms.m_85836_();
                ms.m_252781_(VecHelper.rotateY(i == 0 ? flap : 180.0f - flap));
                ms.m_85837_(-0.9, 0.0, 0.0);
                ms.m_85841_(1.7f, -1.7f, -1.7f);
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, ms, buffers, 0xF000F0, OverlayTexture.f_118083_, model);
                ms.m_85849_();
            }
            ms.m_85849_();
        }

        private static void renderKuroyukihime(HumanoidModel<?> bipedModel, BakedModel model, ItemStack stack, PoseStack ms, MultiBufferSource buffers, float flap) {
            ms.m_85836_();
            bipedModel.f_102810_.m_104299_(ms);
            ms.m_85837_(0.0, -0.4, 0.2);
            for (int i = 0; i < 2; ++i) {
                ms.m_85836_();
                ms.m_252781_(VecHelper.rotateY(i == 0 ? flap : 180.0f - flap));
                ms.m_85837_(-1.3, 0.0, 0.0);
                ms.m_85841_(2.5f, -2.5f, -2.5f);
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.NONE, false, ms, buffers, 0xF000F0, OverlayTexture.f_118083_, model);
                ms.m_85849_();
            }
            ms.m_85849_();
        }

        private static void renderCustomColor(HumanoidModel<?> bipedModel, BakedModel model, LivingEntity living, ItemStack stack, PoseStack ms, MultiBufferSource buffers, float flap, int color) {
            ms.m_85836_();
            bipedModel.f_102810_.m_104299_(ms);
            ms.m_85837_(0.0, 0.0, 0.2);
            for (int i = 0; i < 2; ++i) {
                ms.m_85836_();
                ms.m_252781_(VecHelper.rotateY(i == 0 ? flap : 180.0f - flap));
                ms.m_85837_(-0.7, 0.0, 0.0);
                ms.m_85841_(1.5f, -1.5f, -1.5f);
                RenderHelper.renderItemCustomColor(living, stack, color, ms, buffers, 0xF000F0, OverlayTexture.f_118083_, model);
                ms.m_85849_();
            }
            ms.m_85849_();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            meta = FlugelTiaraItem.getVariant(stack);
            if (meta <= 0 || meta >= MiscellaneousModels.INSTANCE.tiaraWingIcons.length + 1) {
                return;
            }
            model = MiscellaneousModels.INSTANCE.tiaraWingIcons[meta - 1];
            if (!(living instanceof Player)) ** GOTO lbl-1000
            player = (Player)living;
            if (player.m_150110_().f_35935_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            flying = v0;
            flap = 20.0f + (float)((Math.sin((double)((float)living.f_19797_ + partialTicks) * (double)(flying != false ? 0.4f : 0.2f)) + 0.5) * (double)(flying != false ? 30.0f : 5.0f));
            switch (meta) {
                case 1: {
                    Renderer.renderBasic(bipedModel, model, stack, ms, buffers, light, flap);
                    ms.m_85836_();
                    ClientLogic.renderHalo(bipedModel, living, ms, buffers, partialTicks);
                    ms.m_85849_();
                    break;
                }
                case 2: {
                    Renderer.renderSephiroth(bipedModel, model, stack, ms, buffers, light, flap);
                    break;
                }
                case 3: {
                    Renderer.renderCirno(bipedModel, model, stack, ms, buffers, light);
                    break;
                }
                case 4: {
                    Renderer.renderPhoenix(bipedModel, model, stack, ms, buffers, flap);
                    break;
                }
                case 5: {
                    Renderer.renderKuroyukihime(bipedModel, model, stack, ms, buffers, flap);
                    break;
                }
                case 6: 
                case 8: {
                    Renderer.renderBasic(bipedModel, model, stack, ms, buffers, light, flap);
                    break;
                }
                case 7: {
                    alpha = 0.5f + (float)Math.cos((double)((float)living.f_19797_ + partialTicks) * 0.30000001192092896) * 0.2f;
                    color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
                    Renderer.renderCustomColor(bipedModel, model, living, stack, ms, buffers, flap, color);
                    break;
                }
                case 9: {
                    flap = -((float)((Math.sin((double)((float)living.f_19797_ + partialTicks) * 0.20000000298023224) + 0.6000000238418579) * (double)(flying != false ? 12.0f : 5.0f)));
                    alpha = 0.5f + (flying != false ? (float)Math.cos((double)((float)living.f_19797_ + partialTicks) * 0.30000001192092896) * 0.25f + 0.25f : 0.0f);
                    color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
                    Renderer.renderCustomColor(bipedModel, model, living, stack, ms, buffers, flap, color);
                }
            }
        }
    }

    public static class ClientLogic {
        public static void renderHalo(@Nullable HumanoidModel<?> model, @Nullable LivingEntity living, PoseStack ms, MultiBufferSource buffers, float partialTicks) {
            if (model != null) {
                model.f_102810_.m_104299_(ms);
            }
            ms.m_85837_(0.2, -0.65, 0.0);
            ms.m_252781_(VecHelper.rotateZ(30.0f));
            if (living != null) {
                ms.m_252781_(VecHelper.rotateY((float)living.f_19797_ + partialTicks));
            } else {
                ms.m_252781_(VecHelper.rotateY(ClientTickHandler.ticksInGame));
            }
            ms.m_85841_(0.75f, -0.75f, -0.75f);
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.HALO);
            Matrix4f mat = ms.m_85850_().m_252922_();
            buffer.m_252986_(mat, -1.0f, 0.0f, -1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, 1.0f, 0.0f, -1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, 1.0f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, -1.0f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
        }

        public static void renderHUD(GuiGraphics gui, Player player, ItemStack stack) {
            int xo;
            int u = Math.max(1, FlugelTiaraItem.getVariant(stack)) * 9 - 9;
            int v = 0;
            Minecraft mc = Minecraft.m_91087_();
            int x = xo = mc.m_91268_().m_85445_() / 2 + 10;
            int y = mc.m_91268_().m_85446_() - 49;
            if (player.m_204029_(FluidTags.f_13131_)) {
                y -= 10;
            }
            int left = ItemNBTHelper.getInt(stack, FlugelTiaraItem.TAG_TIME_LEFT, 1200);
            int segTime = 120;
            int segs = left / segTime + 1;
            int last = left % segTime;
            for (int i = 0; i < segs; ++i) {
                float trans = 1.0f;
                if (i == segs - 1) {
                    trans = (float)last / (float)segTime;
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
                RenderHelper.drawTexturedModalRect(gui, textureHud, x, y, u, v, 9, 9);
                x += 8;
            }
            if (player.m_150110_().f_35935_) {
                int width = ItemNBTHelper.getInt(stack, FlugelTiaraItem.TAG_DASH_COOLDOWN, 0);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (width > 0) {
                    gui.m_280509_(xo, y - 2, xo + 80, y - 1, -2013265920);
                }
                gui.m_280509_(xo, y - 2, xo + width, y - 1, -1);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

