/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import corgitaco.corgilib.network.UpdateStructureBoxPacketC2S;
import corgitaco.corgilib.platform.ModPlatform;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StructureBoxEditor {
    public static AABB structureBox = null;
    public static BlockPos structureBlockPos;
    public static BlockPos structureOffset;

    public static void render(PoseStack stack, VertexConsumer consumer, double camX, double camY, double camZ, boolean b) {
        if (structureBox != null && structureBlockPos != null && structureOffset != null) {
            AABB aabb = structureBox.m_82338_(structureOffset).m_82338_(structureBlockPos);
            LevelRenderer.m_285900_((PoseStack)stack, (VertexConsumer)consumer, (VoxelShape)Shapes.m_83064_((AABB)aabb), (double)(-camX), (double)(-camY - 1.0), (double)(-camZ), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)b);
        }
    }

    public static boolean onScroll(double scrollValue) {
        LocalPlayer player;
        if (structureBox != null && structureBlockPos != null && structureOffset != null && (player = Minecraft.m_91087_().f_91074_) != null && player.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42433_)) {
            if (!Minecraft.m_91087_().f_91073_.m_8055_(structureBlockPos).m_60713_(Blocks.f_50677_)) {
                player.m_5661_((Component)Component.m_237113_((String)"No longer editing structure block."), true);
                structureBox = null;
                structureBlockPos = null;
                structureOffset = null;
                return false;
            }
            Vec3 eyePosition = player.m_146892_().m_82520_(0.0, 1.0, 0.0);
            Vec3 viewVector = player.m_20252_(0.0f);
            int distance = 250;
            Vec3 add = eyePosition.m_82520_(viewVector.f_82479_ * (double)distance, viewVector.f_82480_ * (double)distance, viewVector.f_82481_ * (double)distance);
            BlockHitResult clip = AABB.m_82342_(Collections.singleton(structureBox.m_82338_(structureOffset).m_82338_(structureBlockPos)), (Vec3)eyePosition, (Vec3)add, (BlockPos)BlockPos.f_121853_);
            if (clip != null && clip.m_6662_() != HitResult.Type.MISS) {
                Direction opposite = clip.m_82434_().m_122424_();
                double xStep = (double)opposite.m_122429_() * scrollValue;
                double yStep = (double)opposite.m_122430_() * scrollValue;
                double zStep = (double)opposite.m_122431_() * scrollValue;
                if (StructureBoxEditor.isKeyDown(Minecraft.m_91087_(), 340)) {
                    structureBox = new AABB(StructureBoxEditor.structureBox.f_82288_, StructureBoxEditor.structureBox.f_82289_, StructureBoxEditor.structureBox.f_82290_, Math.max(StructureBoxEditor.structureBox.f_82288_ + 1.0, StructureBoxEditor.structureBox.f_82291_ + xStep), Math.max(StructureBoxEditor.structureBox.f_82289_ + 1.0, StructureBoxEditor.structureBox.f_82292_ + yStep), Math.max(StructureBoxEditor.structureBox.f_82290_ + 1.0, StructureBoxEditor.structureBox.f_82293_ + zStep));
                    ModPlatform.PLATFORM.sendToServer(new UpdateStructureBoxPacketC2S(structureBlockPos, structureOffset, new BoundingBox((int)StructureBoxEditor.structureBox.f_82288_, (int)StructureBoxEditor.structureBox.f_82289_, (int)StructureBoxEditor.structureBox.f_82290_, (int)StructureBoxEditor.structureBox.f_82291_, (int)StructureBoxEditor.structureBox.f_82292_, (int)StructureBoxEditor.structureBox.f_82293_)));
                    return true;
                }
                if (StructureBoxEditor.isKeyDown(Minecraft.m_91087_(), 341)) {
                    structureOffset = structureOffset.m_7918_((int)xStep, (int)yStep, (int)zStep);
                    ModPlatform.PLATFORM.sendToServer(new UpdateStructureBoxPacketC2S(structureBlockPos, structureOffset, new BoundingBox((int)StructureBoxEditor.structureBox.f_82288_, (int)StructureBoxEditor.structureBox.f_82289_, (int)StructureBoxEditor.structureBox.f_82290_, (int)StructureBoxEditor.structureBox.f_82291_, (int)StructureBoxEditor.structureBox.f_82292_, (int)StructureBoxEditor.structureBox.f_82293_)));
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static AABB getStructureWorldBox(StructureBlockEntity pBlockEntity) {
        BlockPos structurePos = pBlockEntity.m_59902_();
        Vec3i structureSize = pBlockEntity.m_155805_();
        if (structureSize.m_123341_() >= 1 && structureSize.m_123342_() >= 1 && structureSize.m_123343_() >= 1 && pBlockEntity.m_59908_() == StructureMode.SAVE) {
            double maxX;
            double minZ;
            double minX;
            double structureSizeX;
            double structurePosX = structurePos.m_123341_();
            double structurePosZ = structurePos.m_123343_();
            double minY = structurePos.m_123342_();
            double maxY = minY + (double)structureSize.m_123342_();
            double structureSizeZ = switch (pBlockEntity.m_59905_()) {
                case Mirror.LEFT_RIGHT -> {
                    structureSizeX = structureSize.m_123341_();
                    yield -structureSize.m_123343_();
                }
                case Mirror.FRONT_BACK -> {
                    structureSizeX = -structureSize.m_123341_();
                    yield structureSize.m_123343_();
                }
                default -> {
                    structureSizeX = structureSize.m_123341_();
                    yield structureSize.m_123343_();
                }
            };
            double maxZ = switch (pBlockEntity.m_59906_()) {
                case Rotation.CLOCKWISE_90 -> {
                    minX = structureSizeZ < 0.0 ? structurePosX : structurePosX + 1.0;
                    minZ = structureSizeX < 0.0 ? structurePosZ + 1.0 : structurePosZ;
                    maxX = minX - structureSizeZ;
                    yield minZ + structureSizeX;
                }
                case Rotation.CLOCKWISE_180 -> {
                    minX = structureSizeX < 0.0 ? structurePosX : structurePosX + 1.0;
                    minZ = structureSizeZ < 0.0 ? structurePosZ : structurePosZ + 1.0;
                    maxX = minX - structureSizeX;
                    yield minZ - structureSizeZ;
                }
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    minX = structureSizeZ < 0.0 ? structurePosX + 1.0 : structurePosX;
                    minZ = structureSizeX < 0.0 ? structurePosZ : structurePosZ + 1.0;
                    maxX = minX + structureSizeZ;
                    yield minZ - structureSizeX;
                }
                default -> {
                    minX = structureSizeX < 0.0 ? structurePosX + 1.0 : structurePosX;
                    minZ = structureSizeZ < 0.0 ? structurePosZ + 1.0 : structurePosZ;
                    maxX = minX + structureSizeX;
                    yield minZ + structureSizeZ;
                }
            };
            if (pBlockEntity.m_59908_() == StructureMode.SAVE || pBlockEntity.m_59835_()) {
                return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
            }
        }
        return null;
    }

    public static boolean isKeyDown(Minecraft minecraft, int keyValue) {
        long window = minecraft.m_91268_().m_85439_();
        return InputConstants.m_84830_((long)window, (int)keyValue);
    }
}

