/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionForge;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class ItemAction
extends ConfigurableTypeActionForge<ItemConfig, Item> {
    private static final List<ItemConfig> MODEL_ENTRIES = Lists.newArrayList();

    @Override
    public void onRegisterForgeFilled(ItemConfig eConfig) {
        ItemAction.register(eConfig, () -> {
            this.polish(eConfig);
            eConfig.onForgeRegistered();
            return null;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistryLoad(ModelEvent.RegisterAdditional event) {
        for (ItemConfig config : MODEL_ENTRIES) {
            config.dynamicItemVariantLocation = config.registerDynamicModel();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (ItemConfig config : MODEL_ENTRIES) {
            IDynamicModelElement dynamicModelElement = (IDynamicModelElement)config.getInstance();
            if (config.dynamicItemVariantLocation == null) continue;
            event.getModels().put(config.dynamicItemVariantLocation, dynamicModelElement.createDynamicModel(event));
        }
    }

    public static void handleItemModel(ItemConfig extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(ItemConfig config) {
        ItemColor itemColorHandler;
        if (MinecraftHelpers.isClientSide() && (itemColorHandler = config.getItemColorHandler()) != null) {
            Minecraft.m_91087_().getItemColors().m_92689_(itemColorHandler, new ItemLike[]{(ItemLike)config.getInstance()});
        }
    }

    static {
        if (MinecraftHelpers.isClientSide()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ItemAction::onModelRegistryLoad);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ItemAction::onModelBakeEvent);
        }
    }
}

