/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;

public abstract class RegistryExportableRecipeAbstract<T extends RecipeType<? extends R>, R extends Recipe<C>, C extends Container>
implements IRegistryExportable {
    private final Supplier<T> recipeType;

    protected RegistryExportableRecipeAbstract(Supplier<T> recipeType) {
        this.recipeType = recipeType;
    }

    public T getRecipeType() {
        return (T)((RecipeType)this.recipeType.get());
    }

    @Override
    public JsonObject export() {
        JsonObject element = new JsonObject();
        JsonArray elements = new JsonArray();
        element.add("recipes", (JsonElement)elements);
        for (Recipe recipe : CraftingHelpers.findServerRecipes(this.getRecipeType())) {
            JsonObject serializedRecipe = this.serializeRecipe(recipe);
            serializedRecipe.addProperty("id", recipe.m_6423_().toString());
            elements.add((JsonElement)serializedRecipe);
        }
        return element;
    }

    @Override
    public String getName() {
        return ForgeRegistries.RECIPE_TYPES.getKey(this.getRecipeType()).toString().replaceAll(":", "__");
    }

    public abstract JsonObject serializeRecipe(R var1);
}

