/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public class InventoryHelpers {
    public static void dropItems(Level world, Container inventory, BlockPos blockPos) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_() || itemStack.m_41613_() <= 0) continue;
            ItemStackHelpers.spawnItemStack(world, blockPos, inventory.m_8020_(i).m_41777_());
        }
    }

    public static void clearInventory(Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    @Deprecated
    public static void tryReAddToStack(Player player, ItemStack originalStack, ItemStack newStackPart) {
        InventoryHelpers.tryReAddToStack(player, originalStack, newStackPart, InteractionHand.MAIN_HAND);
    }

    public static void tryReAddToStack(Player player, ItemStack originalStack, ItemStack newStackPart, InteractionHand hand) {
        if (!player.m_7500_()) {
            if (!originalStack.m_41619_() && originalStack.m_41613_() == 1) {
                player.m_150109_().m_6836_(hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40, newStackPart);
            } else {
                if (!originalStack.m_41619_()) {
                    originalStack.m_41774_(1);
                }
                if (!player.m_150109_().m_36054_(newStackPart)) {
                    player.m_36176_(newStackPart, false);
                }
            }
        }
    }

    public static void validateNBTStorage(Container inventory, ItemStack itemStack, String tagName) {
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_(tagName)) {
            tag.m_128365_(tagName, (Tag)new ListTag());
        }
        InventoryHelpers.readFromNBT(inventory, tag, tagName);
    }

    public static void readFromNBT(Container inventory, CompoundTag data, String tagName) {
        int j;
        ListTag nbttaglist = data.m_128437_(tagName, 10);
        for (j = 0; j < inventory.m_6643_(); ++j) {
            inventory.m_6836_(j, ItemStack.f_41583_);
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            CompoundTag slot = nbttaglist.m_128728_(j);
            int index = slot.m_128441_("index") ? slot.m_128451_("index") : (int)slot.m_128445_("Slot");
            if (index < 0 || index >= inventory.m_6643_()) continue;
            inventory.m_6836_(index, ItemStack.m_41712_((CompoundTag)slot));
        }
    }

    public static void writeToNBT(Container inventory, CompoundTag data, String tagName) {
        ListTag slots = new ListTag();
        for (int index = 0; index < inventory.m_6643_(); index = (int)((byte)(index + 1))) {
            ItemStack itemStack = inventory.m_8020_(index);
            if (itemStack.m_41619_() || itemStack.m_41613_() <= 0) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128405_("index", index);
            slots.add((Object)slot);
            itemStack.m_41739_(slot);
        }
        data.m_128365_(tagName, (Tag)slots);
    }

    @Deprecated
    public static ItemStack getItemFromIndex(Player player, int itemIndex) {
        return InventoryHelpers.getItemFromIndex(player, itemIndex, InteractionHand.MAIN_HAND);
    }

    @Deprecated
    public static ItemStack getItemFromIndex(Player player, int itemIndex, InteractionHand hand) {
        return InteractionHand.MAIN_HAND.equals((Object)hand) ? (ItemStack)player.m_150109_().f_35974_.get(itemIndex) : player.m_21206_();
    }

    @Deprecated
    public static void setItemAtIndex(Player player, int itemIndex, InteractionHand hand, ItemStack itemStack) {
        if (InteractionHand.MAIN_HAND.equals((Object)hand)) {
            player.m_150109_().m_6836_(itemIndex, itemStack);
        } else {
            player.m_21008_(hand, itemStack);
        }
    }

    public static boolean addToSlot(Container inventory, int slot, ItemStack itemStack) {
        return InventoryHelpers.addToSlot(inventory, slot, itemStack, false);
    }

    public static ItemStack addToStack(ItemStack itemStack, ItemStack toAdd) {
        if (ItemStack.m_150942_((ItemStack)toAdd, (ItemStack)itemStack) && itemStack.m_41613_() < itemStack.m_41741_()) {
            toAdd = toAdd.m_41777_();
            int toAddCount = Math.min(itemStack.m_41741_() - itemStack.m_41613_(), toAdd.m_41613_());
            itemStack.m_41769_(toAddCount);
            toAdd.m_41774_(toAddCount);
        }
        return toAdd;
    }

    public static ItemStack fillSlot(Container inventory, int slot, ItemStack itemStack, boolean simulate) {
        ItemStack produceStack = inventory.m_8020_(slot);
        if (produceStack.m_41619_()) {
            if (!simulate) {
                inventory.m_6836_(slot, itemStack);
            }
            return ItemStack.f_41583_;
        }
        produceStack = produceStack.m_41777_();
        ItemStack remainder = InventoryHelpers.addToStack(produceStack, itemStack);
        if (!simulate && remainder.m_41613_() != itemStack.m_41613_()) {
            inventory.m_6836_(slot, produceStack);
        }
        return remainder;
    }

    public static boolean addToSlot(Container inventory, int slot, ItemStack itemStack, boolean simulate) {
        return InventoryHelpers.fillSlot(inventory, slot, itemStack, simulate).m_41619_();
    }

    public static NonNullList<ItemStack> addToInventory(Container inventory, int[] slots, NonNullList<ItemStack> itemStacks, boolean simulate) {
        NonNullList remaining = NonNullList.m_122779_();
        for (ItemStack itemStack : itemStacks) {
            for (int i = 0; i < slots.length; ++i) {
                int slot = slots[i];
                itemStack = InventoryHelpers.fillSlot(inventory, slot, itemStack, simulate);
                if (simulate) {
                    slots = ArrayUtils.remove((int[])slots, (int)i);
                    --i;
                }
                if (itemStack.m_41619_()) break;
            }
            if (itemStack.m_41619_()) continue;
            remaining.add((Object)itemStack);
        }
        return remaining;
    }

    public static void addStackToList(NonNullList<ItemStack> itemStacks, ItemStack itemStack) {
        boolean added = false;
        ItemStack toAdd = itemStack;
        for (ItemStack existingOutputStack : itemStacks) {
            toAdd = InventoryHelpers.addToStack(existingOutputStack, toAdd);
            if (!toAdd.m_41619_()) continue;
            added = true;
            break;
        }
        if (!added) {
            itemStacks.add((Object)toAdd.m_41777_());
        }
    }
}

