/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife.compat.aether_redux;

import java.util.List;
import java.util.function.Consumer;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.knife.Knives;
import net.brnbrd.delightful.common.item.knife.compat.aether.AetherKnifeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.item.util.VeridiumItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VeridiumKnifeItem
extends AetherKnifeItem
implements VeridiumItem {
    public VeridiumKnifeItem(Tier tier, Item.Properties properties) {
        super("aether_redux", DelightfulItems.ingot("veridium"), tier, properties);
    }

    @Override
    public ItemStack getCreative() {
        ItemStack stack = super.getCreative();
        return this.isCharged((Item)this) ? VeridiumItem.infuse((ItemStack)stack, (int)VeridiumItem.MAXIUMUM_VERIDIUM_INFUSION) : stack;
    }

    public boolean isCharged(Item item) {
        return item == Knives.INFUSED_VERIDIUM.get();
    }

    public Item getReplacementItem(ItemStack itemStack) {
        return this.isCharged(itemStack) ? (Item)Knives.VERIDIUM.get() : (Item)Knives.INFUSED_VERIDIUM.get();
    }

    @Override
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> comps, @NotNull TooltipFlag pIsAdvanced) {
        if (this.enabled()) {
            MutableComponent component = Component.m_237110_((String)"tooltip.aether_redux.ambrosium_charge", (Object[])new Object[]{VeridiumItem.getCharge((ItemStack)pStack)}).m_130940_(ChatFormatting.GRAY);
            comps.add((Component)component);
            Component c = (Component)ReduxItems.TooltipUtils.SHIFT_OR_DEFAULT.apply(Component.m_237115_((String)"gui.aether_redux.infusion_tooltip"));
            comps.add(c);
        }
        super.m_7373_(pStack, pLevel, comps, pIsAdvanced);
    }

    public boolean m_7579_(@NotNull ItemStack pStack, @NotNull LivingEntity pTarget, @NotNull LivingEntity pAttacker) {
        if (!(!this.isCharged(pStack) || pAttacker.m_9236_().m_5776_() || pAttacker instanceof Player && ((Player)pAttacker).m_150110_().f_35937_)) {
            ItemStack stackReplacement = VeridiumItem.decreaseCharge((ItemStack)pStack);
            if (!stackReplacement.m_41720_().equals(pStack.m_41720_())) {
                pAttacker.m_8061_(EquipmentSlot.MAINHAND, stackReplacement);
            } else {
                pStack.m_41751_(stackReplacement.m_41783_());
            }
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public boolean m_6813_(@NotNull ItemStack pStack, @NotNull Level pLevel, BlockState pState, @NotNull BlockPos pPos, @NotNull LivingEntity pEntityLiving) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f && this.isCharged(pStack) && !pEntityLiving.m_9236_().m_5776_()) {
            ItemStack stackReplacement;
            if (pEntityLiving instanceof Player) {
                Player p = (Player)pEntityLiving;
                if (p.m_150110_().f_35937_) {
                    return super.m_6813_(pStack, pLevel, pState, pPos, pEntityLiving);
                }
            }
            if (!(stackReplacement = VeridiumItem.decreaseCharge((ItemStack)pStack)).m_41720_().equals(pStack.m_41720_())) {
                pEntityLiving.m_8061_(EquipmentSlot.MAINHAND, stackReplacement);
            } else {
                pStack.m_41751_(stackReplacement.m_41783_());
            }
        }
        return super.m_6813_(pStack, pLevel, pState, pPos, pEntityLiving);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.isCharged(stack) ? amount * 4 : amount;
    }
}

