/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen;

import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.client.screen.element.button.AutoEjectButton;
import edivad.dimstorage.client.screen.pattern.FrequencyScreen;
import edivad.dimstorage.container.ContainerDimTank;
import edivad.edivadlib.tools.utils.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class ScreenDimTank
extends FrequencyScreen<ContainerDimTank> {
    private static final ResourceLocation DIMTANK_GUI = new ResourceLocation("dimstorage", "textures/gui/dimtank.png");

    public ScreenDimTank(ContainerDimTank container, Inventory inventory, Component text) {
        super(container, container.owner, inventory, text, DIMTANK_GUI, container.isOpen);
    }

    private static int getFluidScaled(int pixels, int currentLiquidAmount) {
        int maxLiquidAmount = 16000;
        int x = currentLiquidAmount * pixels / maxLiquidAmount;
        return pixels - x;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.addComponent((AbstractWidget)new AutoEjectButton(this.f_96543_ / 2 + 95, this.f_96544_ / 2 + 75, (BlockEntityDimTank)this.blockEntityFrequencyOwner));
        this.drawSettings(this.drawSettings);
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        FluidStack liquidStack = ((BlockEntityDimTank)this.blockEntityFrequencyOwner).liquidState.clientLiquid;
        if (!liquidStack.isEmpty()) {
            FluidType fluidType = liquidStack.getFluid().getFluidType();
            String liquidName = liquidStack.getDisplayName().getString();
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.dimstorage.liquid", (Object[])new Object[]{liquidName.substring(0, Math.min(14, liquidName.length()))}), 50, 25, 0x404040, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.dimstorage.amount", (Object[])new Object[]{liquidStack.getAmount()}), 50, 35, 0x404040, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.dimstorage.temperature", (Object[])new Object[]{fluidType.getTemperature() - 273}), 50, 45, 0x404040, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.dimstorage.luminosity", (Object[])new Object[]{fluidType.getLightLevel()}), 50, 55, 0x404040, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.dimstorage.gas").m_130946_(" ").m_7220_((Component)(fluidType.isLighterThanAir() ? Component.m_237115_((String)"gui.dimstorage.yes") : Component.m_237115_((String)"gui.dimstorage.no"))), 50, 65, 0x404040, false);
        } else {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.dimstorage.liquid").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.dimstorage.empty")), 50, 25, 0x404040, false);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        FluidStack fluid = ((BlockEntityDimTank)this.blockEntityFrequencyOwner).liquidState.clientLiquid;
        int z = ScreenDimTank.getFluidScaled(60, fluid.getAmount());
        if (!fluid.isEmpty()) {
            TextureAtlasSprite fluidTexture = FluidUtils.getFluidTexture((FluidStack)fluid);
            if (fluidTexture == null) {
                return;
            }
            int color = FluidUtils.getLiquidColorWithBiome((FluidStack)fluid, (BlockEntity)this.blockEntityFrequencyOwner);
            float red = FluidUtils.getRed((int)color);
            float green = FluidUtils.getGreen((int)color);
            float blue = FluidUtils.getBlue((int)color);
            float alpha = FluidUtils.getAlpha((int)color);
            guiGraphics.m_280565_(this.f_97735_ + 11, this.f_97736_ + 21 + z, 176, 16, 60 - z, fluidTexture, red, green, blue, alpha);
        }
    }
}

