/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.items;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.container.ContainerDimTablet;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.setup.Config;
import edivad.dimstorage.storage.DimChestStorage;
import edivad.dimstorage.tools.InventoryUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;

public class DimTablet
extends Item
implements MenuProvider {
    public DimTablet() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        if (!player.m_6047_()) {
            return InteractionResult.PASS;
        }
        ItemStack device = player.m_21120_(context.m_43724_());
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityDimChest) {
            BlockEntityDimChest dimChest = (BlockEntityDimChest)blockEntity;
            if (dimChest.canAccess(player)) {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("frequency", (Tag)dimChest.getFrequency().serializeNBT());
                tag.m_128379_("bound", true);
                tag.m_128379_("autocollect", false);
                device.m_41751_(tag);
                player.m_5661_((Component)Component.m_237113_((String)"Linked to chest").m_130940_(ChatFormatting.GREEN), false);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237113_((String)"Access Denied!").m_130940_(ChatFormatting.RED), false);
        } else {
            stack.m_41783_().m_128379_("autocollect", !stack.m_41783_().m_128471_("autocollect"));
            if (stack.m_41783_().m_128471_("autocollect")) {
                player.m_5661_((Component)Component.m_237113_((String)"Enabled autocollect").m_130940_(ChatFormatting.GREEN), false);
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"Disabled autocollect").m_130940_(ChatFormatting.RED), false);
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && hand.compareTo((Enum)InteractionHand.MAIN_HAND) == 0) {
            if (player.m_6047_()) {
                return super.m_7203_(level, player, hand);
            }
            if (!stack.m_41784_().m_128471_("bound")) {
                player.m_5661_((Component)Component.m_237113_((String)"Dimensional Tablet not connected to any DimChest").m_130940_(ChatFormatting.RED), false);
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            Frequency f = new Frequency(stack.m_41784_().m_128469_("frequency"));
            if (!f.canAccess(player)) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (!level.f_46443_ && stack.m_41784_().m_128471_("autocollect") && stack.m_41784_().m_128471_("bound") && entity instanceof Player) {
            Player player = (Player)entity;
            Frequency f = new Frequency(stack.m_41784_().m_128469_("frequency"));
            InvWrapper chestInventory = new InvWrapper((Container)this.getStorage(level, f));
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                Item item = player.m_150109_().m_8020_(i).m_41720_();
                if (!Config.DimTablet.containItem(item)) continue;
                InventoryUtils.mergeItemStack(player.m_150109_().m_8020_(i), 0, this.getStorage(level, f).m_6643_(), chestInventory);
            }
        }
    }

    private DimChestStorage getStorage(Level level, Frequency frequency) {
        return (DimChestStorage)DimStorageManager.instance(level.f_46443_).getStorage(frequency, "item");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        MutableComponent ADVICE_TO_LINK = Component.m_237115_((String)"message.dimstorage.press").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"Shift").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.AQUA})).m_7220_((Component)Component.m_237113_((String)" + ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237115_((String)"message.dimstorage.bind_dimchest").m_130940_(ChatFormatting.GRAY));
        MutableComponent HOLD_SHIFT = Component.m_237115_((String)"message.dimstorage.hold").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"Shift").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.AQUA})).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"message.dimstorage.for_details").m_130940_(ChatFormatting.GRAY));
        MutableComponent CHANGE_AUTOCOLLECT = Component.m_237115_((String)"message.dimstorage.press").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"Shift").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.AQUA})).m_7220_((Component)Component.m_237113_((String)" + ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237115_((String)"message.dimstorage.changeAutoCollect").m_130940_(ChatFormatting.GRAY));
        if (level != null) {
            if (!stack.m_41782_() || !stack.m_41783_().m_128471_("bound")) {
                tooltip.add((Component)ADVICE_TO_LINK);
                return;
            }
            CompoundTag tag = stack.m_41783_();
            if (Screen.m_96638_()) {
                Frequency f = new Frequency(tag.m_128469_("frequency"));
                tooltip.add((Component)Component.m_237115_((String)"gui.dimstorage.frequency").m_130946_(" " + f.getChannel()).m_130940_(ChatFormatting.GRAY));
                if (f.hasOwner()) {
                    tooltip.add((Component)Component.m_237115_((String)"gui.dimstorage.owner").m_130946_(" " + f.getOwner()).m_130940_(ChatFormatting.GRAY));
                }
                MutableComponent yes = Component.m_237115_((String)"gui.dimstorage.yes");
                MutableComponent no = Component.m_237115_((String)"gui.dimstorage.no");
                MutableComponent collecting = Component.m_237115_((String)"gui.dimstorage.collecting");
                tooltip.add((Component)collecting.m_130946_(": ").m_7220_((Component)(tag.m_128471_("autocollect") ? yes : no)).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)HOLD_SHIFT);
            }
            tooltip.add((Component)CHANGE_AUTOCOLLECT);
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ContainerDimTablet(id, inventory, player.m_9236_());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_5524_());
    }
}

