/*
 * Decompiled with CFR 0.152.
 */
package com.enderio;

import com.enderio.api.integration.IntegrationManager;
import com.enderio.base.common.advancement.PaintingTrigger;
import com.enderio.base.common.advancement.UseGliderTrigger;
import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.init.EIOBlockEntities;
import com.enderio.base.common.init.EIOBlocks;
import com.enderio.base.common.init.EIOCreativeTabs;
import com.enderio.base.common.init.EIOEnchantments;
import com.enderio.base.common.init.EIOEntities;
import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.init.EIOLootModifiers;
import com.enderio.base.common.init.EIOMenus;
import com.enderio.base.common.init.EIOPackets;
import com.enderio.base.common.init.EIOParticles;
import com.enderio.base.common.init.EIORecipes;
import com.enderio.base.common.integrations.EnderIOSelfIntegration;
import com.enderio.base.common.item.tool.SoulVialItem;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.network.EIONetwork;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.data.EIODataProvider;
import com.enderio.base.data.advancement.EIOAdvancementGenerator;
import com.enderio.base.data.loot.ChestLootProvider;
import com.enderio.base.data.loot.EIOLootModifiersProvider;
import com.enderio.base.data.loot.FireCraftingLootProvider;
import com.enderio.base.data.recipe.BlockRecipeProvider;
import com.enderio.base.data.recipe.FireCraftingRecipeProvider;
import com.enderio.base.data.recipe.GlassRecipeProvider;
import com.enderio.base.data.recipe.GrindingBallRecipeProvider;
import com.enderio.base.data.recipe.ItemRecipeProvider;
import com.enderio.base.data.recipe.MaterialRecipeProvider;
import com.enderio.base.data.tags.EIOBlockTagsProvider;
import com.enderio.base.data.tags.EIOEntityTagsProvider;
import com.enderio.base.data.tags.EIOFluidTagsProvider;
import com.enderio.base.data.tags.EIOItemTagsProvider;
import com.enderio.core.common.network.CoreNetwork;
import com.tterrag.registrate.Registrate;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enderio")
public class EnderIO {
    public static final String MODID = "enderio";
    private static final Lazy<Registrate> REGISTRATE = Lazy.of(() -> Registrate.create((String)MODID));
    public static final Logger LOGGER = LogManager.getLogger((String)"enderio");

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static Registrate registrate() {
        return (Registrate)REGISTRATE.get();
    }

    public EnderIO() {
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve(MODID), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BaseConfig.COMMON_SPEC, "enderio/base-common.toml");
        ctx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BaseConfig.CLIENT_SPEC, "enderio/base-client.toml");
        CoreNetwork.networkInit();
        EIOCreativeTabs.register();
        EIOItems.register();
        EIOBlocks.register();
        EIOBlockEntities.register();
        EIOFluids.register();
        EIOEnchantments.register();
        EIOTags.register();
        EIOMenus.register();
        EIOPackets.register();
        EIOLang.register();
        EIORecipes.register();
        EIOLootModifiers.register();
        EIOParticles.register();
        EIOEntities.register();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(EventPriority.LOWEST, this::onGatherData);
        modEventBus.addListener(SoulVialItem::onCommonSetup);
        IntegrationManager.addIntegration(EnderIOSelfIntegration.INSTANCE);
        new UseGliderTrigger().register();
        new PaintingTrigger().register();
        EIONetwork.register();
        MinecraftForge.EVENT_BUS.addListener(EnderIO::missingMappings);
    }

    public void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        EIODataProvider provider = new EIODataProvider("base");
        provider.addSubProvider(event.includeServer(), (DataProvider)new MaterialRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new BlockRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ItemRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new GrindingBallRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new GlassRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new FireCraftingRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new EIOLootModifiersProvider(packOutput));
        EIOBlockTagsProvider b = new EIOBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        provider.addSubProvider(event.includeServer(), (DataProvider)b);
        provider.addSubProvider(event.includeServer(), (DataProvider)new EIOItemTagsProvider(packOutput, lookupProvider, b.m_274426_(), existingFileHelper));
        provider.addSubProvider(event.includeServer(), (DataProvider)new EIOFluidTagsProvider(packOutput, lookupProvider, existingFileHelper));
        provider.addSubProvider(event.includeServer(), (DataProvider)new EIOEntityTagsProvider(packOutput, lookupProvider, existingFileHelper));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new EIOAdvancementGenerator())));
        provider.addSubProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(FireCraftingLootProvider::new, LootContextParamSets.f_81410_), new LootTableProvider.SubProviderEntry(ChestLootProvider::new, LootContextParamSets.f_81411_))));
        generator.addProvider(true, (DataProvider)provider);
    }

    public static void missingMappings(MissingMappingsEvent event) {
        event.getMappings(Registries.f_256762_, MODID).forEach(mapping -> {
            if (mapping.getKey().equals((Object)EnderIO.loc("withering_blade"))) {
                mapping.remap((Object)((Enchantment)EIOEnchantments.WITHERING.get()));
            } else if (mapping.getKey().equals((Object)EnderIO.loc("withering_arrow"))) {
                mapping.remap((Object)((Enchantment)EIOEnchantments.WITHERING.get()));
            } else if (mapping.getKey().equals((Object)EnderIO.loc("withering_bold"))) {
                mapping.remap((Object)((Enchantment)EIOEnchantments.WITHERING.get()));
            }
        });
    }
}

