/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.block.glass;

import com.enderio.base.common.block.glass.GlassCollisionPredicate;
import com.enderio.base.common.block.glass.GlassIdentifier;
import com.enderio.base.common.block.glass.GlassLighting;
import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.lang.EIOLang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FusedQuartzBlock
extends AbstractGlassBlock {
    private final GlassCollisionPredicate collisionPredicate;
    private final GlassLighting glassLighting;
    private final boolean explosionResistant;
    private final String descriptionId;

    public FusedQuartzBlock(BlockBehaviour.Properties pProps, GlassIdentifier glassIdentifier, @Nullable DyeColor color) {
        super(pProps);
        this.collisionPredicate = glassIdentifier.collisionPredicate();
        this.glassLighting = glassIdentifier.lighting();
        this.explosionResistant = glassIdentifier.explosion_resistance();
        String baseName = this.explosionResistant ? "fused_quartz" : "clear_glass";
        String lightingName = this.glassLighting != GlassLighting.NONE ? "_" + this.glassLighting.shortName() : "";
        String colorName = color != null ? "_" + color.m_41065_() : "";
        this.descriptionId = "block.enderio." + baseName + lightingName + colorName;
    }

    public String m_7705_() {
        return this.descriptionId;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        if (this.explosionResistant) {
            pTooltip.add(EIOLang.BLOCK_BLAST_RESISTANT);
        }
        if (this.glassLighting == GlassLighting.EMITTING) {
            pTooltip.add(EIOLang.FUSED_QUARTZ_EMITS_LIGHT);
        }
        if (this.glassLighting == GlassLighting.BLOCKING) {
            pTooltip.add(EIOLang.FUSED_QUARTZ_BLOCKS_LIGHT);
        }
        this.collisionPredicate.getDescription().ifPresent(pTooltip::add);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.glassLighting == GlassLighting.EMITTING ? 15 : 0;
    }

    public int m_7753_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return this.glassLighting == GlassLighting.BLOCKING ? pLevel.m_7469_() : 0;
    }

    public float m_7325_() {
        return this.explosionResistant ? ((Float)BaseConfig.COMMON.BLOCKS.EXPLOSION_RESISTANCE.get()).floatValue() : super.m_7325_();
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext entityCollisionContext;
        if (pContext instanceof EntityCollisionContext && this.collisionPredicate.canPass(entityCollisionContext = (EntityCollisionContext)pContext)) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(pState, pLevel, pPos, pContext);
    }

    public GlassLighting getGlassLighting() {
        return this.glassLighting;
    }

    public GlassCollisionPredicate getCollisionPredicate() {
        return this.collisionPredicate;
    }
}

