/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.capacitor;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.ICapacitorData;
import com.enderio.base.common.init.EIOCapabilities;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enderio")
public class CapacitorUtil {
    public static void getTooltip(ItemStack stack, List<Component> tooltipComponents) {
    }

    private static String getFlavor(int flavor) {
        return "description.enderio.capacitor.flavor." + flavor;
    }

    private static MutableComponent getBaseText(float base) {
        MutableComponent t = Component.m_237115_((String)("description.enderio.capacitor.base." + (int)Math.ceil(base)));
        t.m_130940_(ChatFormatting.ITALIC);
        return t;
    }

    private static MutableComponent getTypeText(String type) {
        MutableComponent t = Component.m_237115_((String)("description.enderio.capacitor.type." + type));
        t.m_130940_(ChatFormatting.ITALIC);
        return t;
    }

    private static MutableComponent getGradeText(float grade) {
        MutableComponent t = Component.m_237115_((String)("description.enderio.capacitor.grade." + (int)Math.ceil(grade)));
        t.m_130940_(ChatFormatting.ITALIC);
        return t;
    }

    public static Optional<ICapacitorData> getCapacitorData(ItemStack itemStack) {
        LazyOptional capacitorDataCap = itemStack.getCapability(EIOCapabilities.CAPACITOR);
        if (capacitorDataCap.isPresent()) {
            return Optional.of((ICapacitorData)capacitorDataCap.orElseThrow(NullPointerException::new));
        }
        return Optional.empty();
    }

    public static boolean isCapacitor(ItemStack itemStack) {
        LazyOptional capacitorDataCap = itemStack.getCapability(EIOCapabilities.CAPACITOR);
        return capacitorDataCap.isPresent();
    }

    public static CapacitorModifier getRandomModifier(RandomSource randomSource) {
        return CapacitorModifier.SELECTABLE_MODIFIERS.get(randomSource.m_188503_(CapacitorModifier.SELECTABLE_MODIFIERS.size()));
    }
}

