/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.handler;

import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.init.EIORecipes;
import com.enderio.base.common.recipe.FireCraftingRecipe;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enderio")
public class FireCraftingHandler {
    private static final Random RANDOM = new Random();
    private static final ConcurrentMap<FireIndex, Long> FIRE_TRACKER = new ConcurrentHashMap<FireIndex, Long>();
    private static List<FireCraftingRecipe> cachedRecipes;
    private static boolean recipesCached;

    @SubscribeEvent
    public static void onRecipeUpdate(RecipesUpdatedEvent event) {
        recipesCached = false;
    }

    @SubscribeEvent
    public static void on(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            boolean isFire = event.getState().m_60734_() instanceof FireBlock;
            if (FIRE_TRACKER.isEmpty() && !isFire) {
                return;
            }
            BlockPos pos = event.getPos();
            FireIndex fireIndex = new FireIndex(pos, (ResourceKey<Level>)level.m_46472_());
            long gameTime = level.m_46467_();
            Block baseBlock = level.m_8055_(pos.m_7495_()).m_60734_();
            if (!recipesCached) {
                cachedRecipes = level.m_7465_().m_44013_((RecipeType)EIORecipes.FIRE_CRAFTING.type().get());
                recipesCached = false;
            }
            FireCraftingRecipe matchingRecipe = null;
            for (FireCraftingRecipe recipe : cachedRecipes) {
                if (!recipe.isBaseValid(baseBlock) || !recipe.isDimensionValid((ResourceKey<Level>)level.m_46472_())) continue;
                matchingRecipe = recipe;
                break;
            }
            if (matchingRecipe == null) {
                return;
            }
            if (isFire) {
                if (FIRE_TRACKER.size() > 100) {
                    FIRE_TRACKER.values().removeIf(age -> age < gameTime || FIRE_TRACKER.size() > 500);
                }
                FIRE_TRACKER.putIfAbsent(fireIndex, gameTime + (long)((Integer)BaseConfig.COMMON.INFINITY.FIRE_MIN_AGE.get()).intValue());
            } else if (FIRE_TRACKER.containsKey(fireIndex)) {
                if (level.m_8055_(pos).m_60795_() && gameTime > (Long)FIRE_TRACKER.get(fireIndex)) {
                    FireCraftingHandler.spawnInfinityDrops(level, pos, matchingRecipe.getLootTable(), matchingRecipe.getMaxItemDrops());
                }
                FIRE_TRACKER.remove(fireIndex);
            }
        }
    }

    public static void spawnInfinityDrops(ServerLevel level, BlockPos pos, ResourceLocation lootTable, int maxItemDrops) {
        LootParams lootparams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)pos.m_252807_()).m_287235_(LootContextParamSets.f_81412_);
        LootTable table = (LootTable)level.m_7654_().m_278653_().m_278789_(LootDataType.f_278413_, lootTable);
        if (table != null && table != LootTable.f_79105_) {
            ObjectArrayList randomItems = table.m_287195_(lootparams);
            for (int i = 0; i < randomItems.size() && i < maxItemDrops; ++i) {
                ItemStack item = (ItemStack)randomItems.get(i);
                double x = RANDOM.nextFloat() * 0.5f + 0.25f;
                double y = RANDOM.nextFloat() * 0.5f + 0.25f;
                double z = RANDOM.nextFloat() * 0.5f + 0.25f;
                ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, item);
                itemEntity.m_32060_();
                itemEntity.m_6469_(itemEntity.m_269291_().m_269387_(), -100.0f);
                itemEntity.m_7311_(10);
                level.m_7967_((Entity)itemEntity);
                level.m_5594_(null, pos, SoundEvents.f_11930_, SoundSource.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.4f + 0.8f);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (!FIRE_TRACKER.isEmpty() && !event.level.m_46469_().m_46207_(GameRules.f_46131_)) {
            ArrayList<BlockPos> blocksToClear = new ArrayList<BlockPos>();
            long gameTime = event.level.m_46467_();
            for (Map.Entry fire : FIRE_TRACKER.entrySet()) {
                BlockPos pos = ((FireIndex)fire.getKey()).pos();
                if (gameTime <= (Long)fire.getValue()) continue;
                if (event.level.m_8055_(pos).m_60734_() instanceof FireBlock) {
                    blocksToClear.add(pos);
                    continue;
                }
                FIRE_TRACKER.remove(fire.getKey());
            }
            for (BlockPos pos : blocksToClear) {
                event.level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    static {
        recipesCached = false;
    }

    private record FireIndex(BlockPos pos, ResourceKey<Level> dimension) {
    }
}

