/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.network;

import com.enderio.api.conduit.ConduitTypes;
import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.IExtendedConduitData;
import com.enderio.conduits.common.blockentity.ConduitBlockEntity;
import com.enderio.core.common.network.Packet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class C2SSetConduitExtendedData
implements Packet {
    private final BlockPos pos;
    private final IConduitType<?> conduitType;
    private final CompoundTag extendedConduitData;

    public C2SSetConduitExtendedData(BlockPos pos, IConduitType<?> conduitType, IExtendedConduitData<?> extendedConduitData) {
        this.pos = pos;
        this.conduitType = conduitType;
        this.extendedConduitData = extendedConduitData.serializeGuiNBT();
    }

    public C2SSetConduitExtendedData(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.conduitType = (IConduitType)ConduitTypes.getRegistry().getValue(buf.m_130281_());
        this.extendedConduitData = buf.m_130260_();
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getSender() != null && this.conduitType != null;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerLevel level = context.getSender().m_284548_();
        BlockEntity be = level.m_7702_(this.pos);
        if (be instanceof ConduitBlockEntity) {
            ConduitBlockEntity conduitBlockEntity = (ConduitBlockEntity)be;
            conduitBlockEntity.handleExtendedDataUpdate(this.conduitType, this.extendedConduitData);
        }
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130064_(this.pos);
        writeInto.m_130085_(ConduitTypes.getRegistry().getKey(this.conduitType));
        writeInto.m_130079_(this.extendedConduitData);
    }

    public static class Handler
    extends Packet.PacketHandler<C2SSetConduitExtendedData> {
        @Override
        public C2SSetConduitExtendedData fromNetwork(FriendlyByteBuf buf) {
            return new C2SSetConduitExtendedData(buf);
        }

        @Override
        public void toNetwork(C2SSetConduitExtendedData packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

