/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.common.tag.ConduitTags;
import com.enderio.conduits.common.types.EnergyExtendedData;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.Mergeable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.function.TriFunction;

public class EnergyConduitTicker
extends CapabilityAwareConduitTicker<IEnergyStorage> {
    @Override
    public void tickGraph(IConduitType<?> type, List<NodeIdentifier<?>> loadedNodes, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        super.tickGraph(type, loadedNodes, level, graph, isRedstoneActive);
        for (NodeIdentifier<?> node : loadedNodes) {
            EnergyExtendedData energyExtendedData = node.getExtendedConduitData().castTo(EnergyExtendedData.class);
            IEnergyStorage energy = (IEnergyStorage)energyExtendedData.getSelfCap().resolve().orElseThrow();
            if (energy.getEnergyStored() == 0) {
                energyExtendedData.setCapacity(500);
                continue;
            }
            int previousStored = energy.getEnergyStored();
            for (NodeIdentifier<?> otherNode : loadedNodes) {
                for (Direction dir : Direction.values()) {
                    Optional capability;
                    BlockEntity be;
                    if (!otherNode.getIOState(dir).map(NodeIdentifier.IOState::isInsert).orElse(false).booleanValue() || (be = level.m_7702_(otherNode.getPos().m_121945_(dir))) == null || !(capability = be.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).resolve()).isPresent()) continue;
                    IEnergyStorage insert = (IEnergyStorage)capability.get();
                    this.extractEnergy(energy, List.of(insert), 0, i -> {});
                }
            }
            if (energy.getEnergyStored() == 0) {
                if (previousStored == energy.getMaxEnergyStored()) {
                    energyExtendedData.setCapacity(Math.min(1000000000, 2 * energyExtendedData.getCapacity()));
                    continue;
                }
                if (previousStored >= energyExtendedData.getCapacity() / 2) continue;
                energyExtendedData.setCapacity(Math.max(500, energyExtendedData.getCapacity() / 2));
                continue;
            }
            if (energy.getEnergyStored() <= 0) continue;
            energyExtendedData.setCapacity(Math.max(500, energy.getEnergyStored()));
        }
    }

    @Override
    public void tickCapabilityGraph(IConduitType<?> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IEnergyStorage extractHandler = (IEnergyStorage)extract.cap;
            EnergyExtendedData.EnergySidedData sidedExtractData = extract.data.castTo(EnergyExtendedData.class).compute(extract.direction);
            this.extractEnergy(extractHandler, inserts.stream().map(con -> (IEnergyStorage)con.cap).toList(), sidedExtractData.rotatingIndex, i -> {
                sidedExtractData.rotatingIndex = i;
            });
        }
    }

    private void extractEnergy(IEnergyStorage extractHandler, List<IEnergyStorage> inserts, int startingIndex, Consumer<Integer> rotationIndexSetter) {
        int availableForExtraction = extractHandler.extractEnergy(Integer.MAX_VALUE, true);
        if (availableForExtraction <= 0) {
            return;
        }
        if (inserts.size() <= startingIndex) {
            startingIndex = 0;
            rotationIndexSetter.accept(0);
        }
        for (int j = startingIndex; j < startingIndex + inserts.size(); ++j) {
            int insertIndex = j % inserts.size();
            IEnergyStorage insert = inserts.get(insertIndex);
            int inserted = insert.receiveEnergy(availableForExtraction, false);
            extractHandler.extractEnergy(inserted, false);
            if (inserted == availableForExtraction) {
                rotationIndexSetter.accept(startingIndex + insertIndex + 1);
                return;
            }
            availableForExtraction -= inserted;
        }
    }

    @Override
    public int getTickRate() {
        return 1;
    }

    @Override
    public Capability<IEnergyStorage> getCapability() {
        return ForgeCapabilities.ENERGY;
    }

    @Override
    public boolean canConnectTo(Level level, BlockPos conduitPos, Direction direction) {
        return super.canConnectTo(level, conduitPos, direction) && !level.m_8055_(conduitPos.m_121945_(direction)).m_204336_(ConduitTags.Blocks.ENERGY_CABLE);
    }
}

