/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.blockentity;

import com.enderio.api.UseOnly;
import com.enderio.api.capability.IEnderCapabilityProvider;
import com.enderio.core.common.network.C2SDataSlotChange;
import com.enderio.core.common.network.CoreNetwork;
import com.enderio.core.common.network.S2CDataSlotUpdate;
import com.enderio.core.common.network.slot.NetworkDataSlot;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderBlockEntity
extends BlockEntity {
    public static final String DATA = "Data";
    public static final String INDEX = "Index";
    private final List<NetworkDataSlot<?>> dataSlots = new ArrayList();
    private final List<Runnable> afterDataSync = new ArrayList<Runnable>();
    private final Map<Capability<?>, IEnderCapabilityProvider<?>> capabilityProviders = new HashMap();

    public EnderBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnderBlockEntity blockEntity) {
        if (level.f_46443_) {
            blockEntity.clientTick();
        } else {
            blockEntity.serverTick();
        }
    }

    public void serverTick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.sync();
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }

    public void clientTick() {
    }

    public CompoundTag m_5995_() {
        ListTag dataList = new ListTag();
        for (int i = 0; i < this.dataSlots.size(); ++i) {
            NetworkDataSlot<?> slot = this.dataSlots.get(i);
            Tag nbt = slot.serializeNBT(true);
            if (nbt == null) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128405_(INDEX, i);
            slotTag.m_128365_(DATA, nbt);
            dataList.add((Object)slotTag);
        }
        CompoundTag data = new CompoundTag();
        data.m_128365_(DATA, (Tag)dataList);
        return data;
    }

    public void handleUpdateTag(CompoundTag syncData) {
        if (syncData.m_128425_(DATA, 9)) {
            ListTag dataList = syncData.m_128437_(DATA, 10);
            for (Tag dataEntry : dataList) {
                if (!(dataEntry instanceof CompoundTag)) continue;
                CompoundTag slotData = (CompoundTag)dataEntry;
                int slotIdx = slotData.m_128451_(INDEX);
                this.dataSlots.get(slotIdx).fromNBT(slotData.m_128423_(DATA));
            }
            for (Runnable task : this.afterDataSync) {
                task.run();
            }
        }
    }

    @Nullable
    private FriendlyByteBuf createBufferSlotUpdate() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        int amount = 0;
        for (int i = 0; i < this.dataSlots.size(); ++i) {
            NetworkDataSlot<?> networkDataSlot = this.dataSlots.get(i);
            if (!networkDataSlot.needsUpdate()) continue;
            ++amount;
            buf.writeInt(i);
            networkDataSlot.writeBuffer(buf);
        }
        if (amount == 0) {
            return null;
        }
        FriendlyByteBuf result = new FriendlyByteBuf(Unpooled.buffer());
        result.writeInt(amount);
        result.writeBytes(buf.copy());
        return result;
    }

    public void addDataSlot(NetworkDataSlot<?> slot) {
        this.dataSlots.add(slot);
    }

    public void addAfterSyncRunnable(Runnable runnable) {
        this.afterDataSync.add(runnable);
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public <T> void clientUpdateSlot(@Nullable NetworkDataSlot<T> slot, T value) {
        if (slot == null) {
            return;
        }
        if (this.dataSlots.contains(slot)) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(this.dataSlots.indexOf(slot));
            slot.toBuffer(buf, value);
            CoreNetwork.sendToServer(new C2SDataSlotChange(this.m_58899_(), buf));
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 1);
        }
    }

    @UseOnly(value=LogicalSide.SERVER)
    public void sync() {
        FriendlyByteBuf syncData = this.createBufferSlotUpdate();
        if (syncData != null) {
            CoreNetwork.sendToTracking(this.f_58857_.m_46745_(this.m_58899_()), new S2CDataSlotUpdate(this.m_58899_(), syncData));
        }
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public void clientHandleBufferSync(FriendlyByteBuf buf) {
        for (int amount = buf.readInt(); amount > 0; --amount) {
            int index = buf.readInt();
            this.dataSlots.get(index).fromBuffer(buf);
        }
        for (Runnable task : this.afterDataSync) {
            task.run();
        }
    }

    @UseOnly(value=LogicalSide.SERVER)
    public void serverHandleBufferChange(FriendlyByteBuf buf) {
        int index = -1;
        try {
            index = buf.readInt();
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid buffer was passed over the network to the server.");
        }
        this.dataSlots.get(index).fromBuffer(buf);
        this.dataSlots.get(index).updateServerCallback();
    }

    public Map<Capability<?>, IEnderCapabilityProvider<?>> getCapabilityProviders() {
        return this.capabilityProviders;
    }

    public void addCapabilityProvider(IEnderCapabilityProvider<?> provider) {
        this.capabilityProviders.put(provider.getCapabilityType(), provider);
    }

    public void invalidateCaps(@Nullable Direction side) {
        for (IEnderCapabilityProvider<?> capProvider : this.capabilityProviders.values()) {
            capProvider.invalidateSide(side);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.capabilityProviders.containsKey(cap)) {
            return this.capabilityProviders.get(cap).getCapability(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (IEnderCapabilityProvider<?> provider : this.capabilityProviders.values()) {
            provider.invalidateCaps();
        }
    }
}

