/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.gui.widget;

import com.enderio.core.client.gui.widgets.EIOWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidStackWidget
extends EIOWidget {
    private final Screen displayOn;
    private final Supplier<FluidTank> getFluid;

    public FluidStackWidget(Screen displayOn, Supplier<FluidTank> getFluid, int pX, int pY, int pWidth, int pHeight) {
        super(pX, pY, pWidth, pHeight);
        this.displayOn = displayOn;
        this.getFluid = getFluid;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        FluidTank fluidTank = this.getFluid.get();
        if (!fluidTank.isEmpty()) {
            AbstractTexture texture;
            FluidStack fluidStack = fluidTank.getFluid();
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation still = props.getStillTexture(fluidStack);
            if (still != null && (texture = minecraft.m_91097_().m_118506_(TextureAtlas.f_118259_)) instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                TextureAtlasSprite sprite = atlas.m_118316_(still);
                int color = props.getTintColor();
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13655_((int)color) / 255.0f));
                RenderSystem.enableBlend();
                int stored = fluidTank.getFluidAmount();
                float capacity = fluidTank.getCapacity();
                float filledVolume = (float)stored / capacity;
                int renderableHeight = (int)(filledVolume * (float)this.height);
                int atlasWidth = (int)((float)sprite.m_245424_().m_246492_() / (sprite.m_118410_() - sprite.m_118409_()));
                int atlasHeight = (int)((float)sprite.m_245424_().m_245330_() / (sprite.m_118412_() - sprite.m_118411_()));
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, (float)(this.height - 16), 0.0f);
                int i = 0;
                while ((double)i < Math.ceil((float)renderableHeight / 16.0f)) {
                    int drawingHeight = Math.min(16, renderableHeight - 16 * i);
                    int notDrawingHeight = 16 - drawingHeight;
                    guiGraphics.m_280398_(TextureAtlas.f_118259_, this.x, this.y + notDrawingHeight, 0, sprite.m_118409_() * (float)atlasWidth, sprite.m_118411_() * (float)atlasHeight + (float)notDrawingHeight, this.width, drawingHeight, atlasWidth, atlasHeight);
                    guiGraphics.m_280168_().m_252880_(0.0f, -16.0f, 0.0f);
                    ++i;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280168_().m_85849_();
            }
            this.renderToolTip(guiGraphics, mouseX, mouseY);
        }
        RenderSystem.disableDepthTest();
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            guiGraphics.m_280245_(this.displayOn.getMinecraft().f_91062_, Arrays.asList(this.getFluid.get().getFluid().getDisplayName().m_7532_(), Component.m_237113_((String)(this.getFluid.get().getFluidAmount() + "mB")).m_7532_()), mouseX, mouseY);
        }
    }
}

