/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.api.capability.IEntityStorage;
import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.api.capability.StoredEntityData;
import com.enderio.base.common.capability.EntityStorageItemStack;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.util.EntityCaptureUtils;
import com.enderio.core.client.item.IAdvancedTooltipProvider;
import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.TooltipUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="enderio")
public class SoulVialItem
extends Item
implements IMultiCapabilityItem,
IAdvancedTooltipProvider {
    public SoulVialItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_5812_(ItemStack pStack) {
        return pStack.getCapability(EIOCapabilities.ENTITY_STORAGE).map(IEntityStorage::hasStoredEntity).orElse(false);
    }

    @Override
    public void addCommonTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        itemStack.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(entityStorage -> entityStorage.getStoredEntityData().getEntityType().ifPresent(entityType -> tooltips.add(TooltipUtil.style(Component.m_237115_((String)EntityUtil.getEntityDescriptionId(entityType))))));
    }

    @Override
    public void addDetailedTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        itemStack.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(entityStorage -> entityStorage.getStoredEntityData().getHealthState().ifPresent(health -> tooltips.add(TooltipUtil.styledWithArgs(EIOLang.SOUL_VIAL_TOOLTIP_HEALTH, health.m_14418_(), health.m_14419_()))));
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (pPlayer.m_9236_().f_46443_) {
            return InteractionResult.FAIL;
        }
        Optional<ItemStack> itemStack = SoulVialItem.catchEntity(pStack, pInteractionTarget, component -> pPlayer.m_5661_(component, true));
        if (itemStack.isPresent()) {
            ItemStack filledVial = itemStack.get();
            ItemStack hand = pPlayer.m_21120_(pUsedHand);
            if (hand.m_41619_()) {
                hand.m_41764_(1);
                pPlayer.m_21008_(pUsedHand, filledVial);
            } else if (!pPlayer.m_36356_(filledVial)) {
                pPlayer.m_36176_(filledVial, false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (pContext.m_43725_().f_46443_) {
            return InteractionResult.FAIL;
        }
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        return SoulVialItem.releaseEntity(pContext.m_43725_(), pContext.m_43722_(), pContext.m_43719_(), pContext.m_8083_(), emptyVial -> player.m_21008_(pContext.m_43724_(), emptyVial));
    }

    private static Optional<ItemStack> catchEntity(ItemStack soulVial, LivingEntity entity, Consumer<Component> displayCallback) {
        Mob mob;
        if (entity instanceof Player) {
            displayCallback.accept(EIOLang.SOUL_VIAL_ERROR_PLAYER);
            return Optional.empty();
        }
        EntityCaptureUtils.CapturableStatus status = EntityCaptureUtils.getCapturableStatus((EntityType<? extends LivingEntity>)entity.m_6095_(), (Entity)entity);
        if (status != EntityCaptureUtils.CapturableStatus.CAPTURABLE) {
            displayCallback.accept(status.errorMessage());
            return Optional.empty();
        }
        if (!entity.m_6084_()) {
            displayCallback.accept(EIOLang.SOUL_VIAL_ERROR_DEAD);
            return Optional.empty();
        }
        if (entity instanceof Mob && (mob = (Mob)entity).m_21524_() != null) {
            mob.m_21455_(true, true);
        }
        soulVial.m_41774_(1);
        ItemStack filledVial = ((SoulVialItem)EIOItems.FILLED_SOUL_VIAL.get()).m_7968_();
        SoulVialItem.setEntityData(filledVial, entity);
        entity.m_146870_();
        return Optional.of(filledVial);
    }

    private static InteractionResult releaseEntity(Level level, ItemStack filledVial, Direction face, BlockPos pos, Consumer<ItemStack> emptyVialSetter) {
        filledVial.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(entityStorage -> {
            if (entityStorage.hasStoredEntity()) {
                StoredEntityData entityData = entityStorage.getStoredEntityData();
                double spawnX = (double)(pos.m_123341_() + face.m_122429_()) + 0.5;
                double spawnY = pos.m_123342_() + face.m_122430_();
                double spawnZ = (double)(pos.m_123343_() + face.m_122431_()) + 0.5;
                float rotation = Mth.m_14177_((float)(level.m_213780_().m_188501_() * 360.0f));
                Optional entity = EntityType.m_20642_((CompoundTag)entityData.getEntityTag(), (Level)level);
                entity.ifPresent(ent -> {
                    ent.m_6034_(spawnX, spawnY, spawnZ);
                    ent.m_146922_(rotation);
                    level.m_7967_(ent);
                });
                emptyVialSetter.accept(((SoulVialItem)EIOItems.EMPTY_SOUL_VIAL.get()).m_7968_());
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static List<ItemStack> getAllFilled() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ResourceLocation entity : EntityCaptureUtils.getCapturableEntities()) {
            ItemStack is = ((SoulVialItem)EIOItems.FILLED_SOUL_VIAL.get()).m_7968_();
            SoulVialItem.setEntityType(is, entity);
            items.add(is);
        }
        return items;
    }

    public static void setEntityType(ItemStack stack, ResourceLocation entityType) {
        stack.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(storage -> storage.setStoredEntityData(StoredEntityData.of(entityType)));
    }

    private static void setEntityData(ItemStack stack, LivingEntity entity) {
        stack.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(storage -> storage.setStoredEntityData(StoredEntityData.of(entity)));
    }

    public static Optional<StoredEntityData> getEntityData(ItemStack stack) {
        return stack.getCapability(EIOCapabilities.ENTITY_STORAGE).map(IEntityStorage::getStoredEntityData);
    }

    @Override
    @Nullable
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        if (this == EIOItems.FILLED_SOUL_VIAL.get()) {
            provider.add(EIOCapabilities.ENTITY_STORAGE, LazyOptional.of(() -> new EntityStorageItemStack(stack)));
        }
        return provider;
    }

    @SubscribeEvent
    public static void onLivingInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_150930_((Item)EIOItems.EMPTY_SOUL_VIAL.get()) && (event.getTarget() instanceof AbstractChestedHorse || event.getTarget() instanceof Villager)) {
            stack.m_41647_(event.getEntity(), (LivingEntity)event.getTarget(), event.getHand());
        }
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)EIOItems.FILLED_SOUL_VIAL.get()), (DispenseItemBehavior)new EmptySoulVialDispenseBehavior());
            DispenserBlock.m_52672_((ItemLike)((ItemLike)EIOItems.EMPTY_SOUL_VIAL.get()), (DispenseItemBehavior)new FillSoulVialDispenseBehavior());
        });
    }

    private static class EmptySoulVialDispenseBehavior
    extends OptionalDispenseItemBehavior {
        private EmptySoulVialDispenseBehavior() {
        }

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction dispenserDirection = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            AtomicReference emptyVial = new AtomicReference();
            SoulVialItem.releaseEntity((Level)source.m_7727_(), stack, dispenserDirection, source.m_7961_(), emptyVial::set);
            if (emptyVial.get() != null) {
                return (ItemStack)emptyVial.get();
            }
            this.m_123573_(false);
            return stack;
        }
    }

    private static class FillSoulVialDispenseBehavior
    extends OptionalDispenseItemBehavior {
        private FillSoulVialDispenseBehavior() {
        }

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            for (LivingEntity livingentity : source.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), living -> !(living instanceof Player))) {
                Optional<ItemStack> filledVial = SoulVialItem.catchEntity(stack, livingentity, component -> {});
                if (!filledVial.isPresent()) continue;
                source.m_8118_().getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (!handler.insertItem(i, (ItemStack)filledVial.get(), true).m_41619_()) continue;
                        handler.insertItem(i, (ItemStack)filledVial.get(), false);
                        break;
                    }
                });
                return stack;
            }
            this.m_123573_(false);
            return stack;
        }
    }
}

