/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.UseOnly;
import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.task.PoweredCraftingMachineTask;
import com.enderio.machines.common.blockentity.task.host.CraftingMachineTaskHost;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.SoulBinderMenu;
import com.enderio.machines.common.recipe.RecipeCaches;
import com.enderio.machines.common.recipe.SoulBindingRecipe;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SoulBinderBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SOUL_BINDER_CAPACITY);
    public static final QuadraticScalable USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SOUL_BINDER_USAGE);
    public static final SingleSlotAccess INPUT_SOUL = new SingleSlotAccess();
    public static final SingleSlotAccess INPUT_OTHER = new SingleSlotAccess();
    public static final MultiSlotAccess OUTPUT = new MultiSlotAccess();
    private final SoulBindingRecipe.Container fakeContainer = new SoulBindingRecipe.Container((IItemHandlerModifiable)this.getInventoryNN(), () -> Integer.MAX_VALUE);
    @Nullable
    private SoulBindingRecipe recipe;
    @UseOnly(value=LogicalSide.CLIENT)
    private int clientExp = 0;
    private final CraftingMachineTaskHost<SoulBindingRecipe, SoulBindingRecipe.Container> craftingTaskHost;

    public SoulBinderBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, CAPACITY, USAGE, type, worldPosition, blockState);
        this.addDataSlot(new IntegerNetworkDataSlot(() -> this.getFluidTankNN().getFluidInTank(0).getAmount(), i -> this.getFluidTankNN().setFluid(new FluidStack((Fluid)EIOFluids.XP_JUICE.get(), i.intValue()))));
        this.craftingTaskHost = new CraftingMachineTaskHost<SoulBindingRecipe, SoulBindingRecipe.Container>(this, this::hasEnergy, (RecipeType)MachineRecipes.SOUL_BINDING.type().get(), new SoulBindingRecipe.Container((IItemHandlerModifiable)this.getInventoryNN(), () -> ((FluidTank)this.getFluidTankNN()).getFluidAmount()), this::createTask);
        this.addDataSlot(new IntegerNetworkDataSlot(() -> this.recipe == null ? 0 : this.recipe.getExpCost(), i -> {
            this.clientExp = i;
        }));
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SoulBinderMenu(this, pPlayerInventory, pContainerId);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.canAct()) {
            this.craftingTaskHost.tick();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.craftingTaskHost.onLevelReady();
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().setStackLimit(1).inputSlot((slot, stack) -> stack.m_150930_((Item)EIOItems.FILLED_SOUL_VIAL.get())).slotAccess(INPUT_SOUL).inputSlot(this::isValidInput).slotAccess(INPUT_OTHER).setStackLimit(64).outputSlot(2).slotAccess(OUTPUT).capacitor().build();
    }

    private boolean isValidInput(int index, ItemStack stack) {
        return RecipeCaches.SOUL_BINDING.hasRecipe(List.of(stack));
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        this.recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)MachineRecipes.SOUL_BINDING.type().get(), (Container)this.fakeContainer, this.f_58857_).orElse(null);
        this.craftingTaskHost.newTaskAvailable();
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public int getClientExp() {
        return this.clientExp;
    }

    @Override
    @Nullable
    protected FluidTank createFluidTank() {
        return new FluidTank(10000, f -> f.getFluid().m_205067_(EIOTags.Fluids.EXPERIENCE)){

            protected void onContentsChanged() {
                SoulBinderBlockEntity.this.craftingTaskHost.newTaskAvailable();
                SoulBinderBlockEntity.this.updateMachineState(MachineState.EMPTY_TANK, this.getFluidAmount() <= 0);
                SoulBinderBlockEntity.this.recipe = SoulBinderBlockEntity.this.f_58857_.m_7465_().m_44015_((RecipeType)MachineRecipes.SOUL_BINDING.type().get(), (Container)SoulBinderBlockEntity.this.fakeContainer, SoulBinderBlockEntity.this.f_58857_).orElse(null);
                SoulBinderBlockEntity.this.m_6596_();
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (this.isFluidValid(resource)) {
                    Fluid currentFluid = this.getFluid().getFluid();
                    if (currentFluid == Fluids.f_76191_ || resource.getFluid().m_6212_(currentFluid)) {
                        return super.fill(resource, action);
                    }
                    return super.fill(new FluidStack(currentFluid, resource.getAmount()), action);
                }
                return 0;
            }
        };
    }

    public float getCraftingProgress() {
        return this.craftingTaskHost.getProgress();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.craftingTaskHost.hasTask();
    }

    protected PoweredCraftingMachineTask<SoulBindingRecipe, SoulBindingRecipe.Container> createTask(Level level, SoulBindingRecipe.Container container, @Nullable SoulBindingRecipe recipe) {
        return new PoweredCraftingMachineTask<SoulBindingRecipe, SoulBindingRecipe.Container>(level, this.getInventoryNN(), this.getEnergyStorage(), container, OUTPUT, recipe){

            @Override
            protected void consumeInputs(SoulBindingRecipe recipe) {
                INPUT_SOUL.getItemStack(this.getInventory()).m_41774_(1);
                INPUT_OTHER.getItemStack(this.getInventory()).m_41774_(1);
                FluidTank fluidTank = SoulBinderBlockEntity.this.getFluidTankNN();
                int leftover = ExperienceUtil.getLevelFromFluidWithLeftover(fluidTank.getFluidAmount(), 0, recipe.getExpCost()).experience();
                fluidTank.drain(fluidTank.getFluidAmount() - leftover * ExperienceUtil.EXP_TO_FLUID, IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.craftingTaskHost.save(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.craftingTaskHost.load(pTag);
    }
}

