/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleDarkSmokeData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ParticleDarkSmokeData> DESERIALIZER = new ParticleOptions.Deserializer<ParticleDarkSmokeData>(){
        public boolean entityDead;

        public ParticleDarkSmokeData fromCommand(ParticleType<ParticleDarkSmokeData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            this.entityDead = reader.readBoolean();
            return new ParticleDarkSmokeData(this.entityDead);
        }

        public ParticleDarkSmokeData fromNetwork(ParticleType<ParticleDarkSmokeData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ParticleDarkSmokeData(buffer.readBoolean());
        }
    };
    public static final Codec<ParticleDarkSmokeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("dead").forGetter(ParticleDarkSmokeData::isEntityDead)).apply((Applicative)builder, ParticleDarkSmokeData::new));
    private final boolean entityDead;

    public ParticleDarkSmokeData(boolean entityDead) {
        this.entityDead = entityDead;
    }

    public boolean isEntityDead() {
        return this.entityDead;
    }

    public ParticleType<?> m_6012_() {
        return RegistryEntries.PARTICLE_DARK_SMOKE;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.entityDead);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.entityDead);
    }
}

