/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.algorithm;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class OrganicSpread {
    private static Random random = new Random();
    private Level world;
    private int dimensions;
    private int radius;
    private IOrganicSpreadable spreadable;

    public OrganicSpread(Level world, int dimensions, int radius, IOrganicSpreadable spreadable) {
        this.world = world;
        this.setDimensions(dimensions);
        this.setRadius(radius);
        this.setSpreadable(spreadable);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public IOrganicSpreadable getSpreadable() {
        return this.spreadable;
    }

    public void setSpreadable(IOrganicSpreadable spreadable) {
        this.spreadable = spreadable;
    }

    public void spreadTick(BlockPos startLocation) {
        Vec3 newLocation = new Vec3((double)startLocation.m_123341_(), (double)startLocation.m_123342_(), (double)startLocation.m_123343_());
        BlockPos newLocationConcrete = BlockPos.m_274446_((Position)newLocation);
        Vec3 direction = this.getRandomDirection();
        for (int attempts = 10; !this.isBigEnough(direction) && attempts > 0; --attempts) {
            direction = this.getRandomDirection();
        }
        if (!this.isBigEnough(direction)) {
            return;
        }
        while (this.getSpreadable().isDone(this.world, newLocationConcrete) && this.isInArea(startLocation, newLocationConcrete)) {
            newLocation = newLocation.m_82549_(direction);
            newLocationConcrete = BlockPos.m_274446_((Position)newLocation);
        }
        if (!this.getSpreadable().isDone(this.world, newLocationConcrete)) {
            this.getSpreadable().spreadTo(this.world, newLocationConcrete);
        }
    }

    protected boolean isInArea(BlockPos center, BlockPos location) {
        return Math.sqrt(center.m_123331_((Vec3i)location)) <= (double)this.getRadius();
    }

    protected boolean isBigEnough(Vec3 direction) {
        float MIN = 0.3f;
        return Math.abs(direction.f_82479_) >= (double)MIN || Math.abs(direction.f_82480_) >= (double)MIN || Math.abs(direction.f_82481_) >= (double)MIN;
    }

    protected Vec3 getRandomDirection() {
        return new Vec3((double)((random.nextFloat() * 2.0f - 1.0f) / 2.0f), (double)((random.nextFloat() * 2.0f - 1.0f) / 2.0f), (double)((random.nextFloat() * 2.0f - 1.0f) / 2.0f));
    }

    public static interface IOrganicSpreadable {
        public boolean isDone(Level var1, BlockPos var2);

        public void spreadTo(Level var1, BlockPos var2);
    }
}

