/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;

public class EnchantmentPoisonTip
extends Enchantment {
    private static final int POISON_BASE_DURATION = 2;

    public EnchantmentPoisonTip() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.BOW, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void poisonTipEvent(LivingAttackEvent event) {
        LivingEntity entity;
        ItemStack itemStack;
        int enchantmentListID;
        if (!event.getEntity().m_20193_().m_5776_() && event.getSource().m_7639_() instanceof LivingEntity && (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)(itemStack = (entity = (LivingEntity)event.getSource().m_7639_()).m_21205_()), (Enchantment)this)) > -1) {
            int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)itemStack, (int)enchantmentListID);
            EnchantmentPoisonTip.poison(event.getEntity(), level);
            return;
        }
    }

    public int m_6183_(int level) {
        return 10 + (level - 1) * 10;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 3;
    }

    public static void poison(LivingEntity entity, int level) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40 * (level + 1), 1));
    }
}

