/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import jackyy.exchangers.client.RenderTypeExt;
import jackyy.exchangers.client.gui.ExchangersGuiScreen;
import jackyy.exchangers.client.keybind.Keys;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.handler.network.NetworkHandler;
import jackyy.exchangers.handler.network.packet.PacketSwitchMode;
import jackyy.exchangers.handler.network.packet.PacketSwitchRange;
import jackyy.exchangers.handler.network.packet.PacketToggleDirectionalPlacement;
import jackyy.exchangers.handler.network.packet.PacketToggleForceDropItems;
import jackyy.exchangers.handler.network.packet.PacketToggleFuzzyPlacement;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.item.special.ItemCreativeExchanger;
import jackyy.gunpowderlib.helper.NBTHelper;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventsHandler {
    private static Minecraft mc = Minecraft.m_91087_();

    @SubscribeEvent
    public void onGameOverlayRender(RenderGuiOverlayEvent.Post event) {
        ItemStack stack;
        if (ClientEventsHandler.mc.f_91074_ != null && ClientEventsHandler.mc.f_91073_ != null && Minecraft.m_91404_() && !ClientEventsHandler.mc.f_91066_.f_92063_ && ClientEventsHandler.mc.f_91080_ == null && !(stack = ClientEventsHandler.mc.f_91074_.m_21205_()).m_41619_() && stack.m_41720_() instanceof ItemExchangerBase && NBTHelper.hasTag((ItemStack)stack)) {
            Window mainWindow = mc.m_91268_();
            Font font = ClientEventsHandler.mc.f_91062_;
            int w = mainWindow.m_85445_();
            int h = mainWindow.m_85446_();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            String exchangeRange = ExchangerHandler.rangeList[NBTHelper.getTag((ItemStack)stack).m_128451_("range")];
            float scale = exchangeRange.length() > 2 ? 1.0f : 1.0f;
            float swidth = (float)font.m_92895_(exchangeRange) * scale;
            poseStack.m_85837_((double)w / 2.0 - 2.0 - (double)swidth, (double)h / 2.0 - 4.0, 0.0);
            poseStack.m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280056_(font, exchangeRange, 0, 0, 0xFFFFFF, true);
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public void renderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            HitResult mouseOver = Minecraft.m_91087_().f_91077_;
            LocalPlayer player = ClientEventsHandler.mc.f_91074_;
            if (player != null && mouseOver instanceof BlockHitResult) {
                BlockHitResult mouseOverBlock = (BlockHitResult)mouseOver;
                Level world = player.m_9236_();
                BlockPos pos = mouseOverBlock.m_82425_();
                BlockState state = world.m_8055_(pos);
                ItemStack stack = player.m_21205_();
                if (!stack.m_41619_() && stack.m_41720_() instanceof ItemExchangerBase && stack.m_41783_() != null && !state.m_60795_() && !(state.m_60734_() instanceof LiquidBlock)) {
                    BlockState exState = NbtUtils.m_247651_((HolderGetter)world.m_246945_(Registries.f_256747_), (CompoundTag)NBTHelper.getTag((ItemStack)stack).m_128469_("blockstate"));
                    float blockHardness = state.m_60800_((BlockGetter)world, pos);
                    if (exState == state) {
                        return;
                    }
                    Set<BlockPos> blocks = ExchangerHandler.findSuitableBlocks(stack, player.m_9236_(), (Player)player, mouseOverBlock.m_82434_(), pos, state);
                    PoseStack matrixStack = event.getPoseStack();
                    MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
                    if (player.m_6144_() && (world.m_7702_(pos) != null && !ExchangerHandler.isWhitelisted(world, pos) || ExchangerHandler.isBlacklisted(world, pos) || !(stack.m_41720_() instanceof ItemCreativeExchanger) && blockHardness < -0.1f)) {
                        this.renderExchangerRange(matrixStack, bufferSource, blocks, 1.0f, 0.1f, 0.1f, 1.0f);
                    } else if (player.m_6144_()) {
                        this.renderExchangerRange(matrixStack, bufferSource, blocks, 0.1f, 1.0f, 0.1f, 1.0f);
                    } else {
                        this.renderExchangerRange(matrixStack, bufferSource, blocks, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private void renderExchangerRange(PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource, Set<BlockPos> blocks, float r, float g, float b, float a) {
        VertexConsumer builder = bufferSource.m_6299_(RenderTypeExt.BLOCK_OUTLINES);
        matrixStack.m_85836_();
        Vec3 projectedView = ClientEventsHandler.mc.f_91063_.m_109153_().m_90583_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        Matrix4f posMatrix = matrixStack.m_85850_().m_252922_();
        for (BlockPos pos : blocks) {
            float x = pos.m_123341_();
            float y = pos.m_123342_();
            float z = pos.m_123343_();
            builder.m_252986_(posMatrix, x, y, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y + 1.0f, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y + 1.0f, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y + 1.0f, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y + 1.0f, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y + 1.0f, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y + 1.0f, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y + 1.0f, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y + 1.0f, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y + 1.0f, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y + 1.0f, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y + 1.0f, z).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x + 1.0f, y, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
            builder.m_252986_(posMatrix, x, y + 1.0f, z + 1.0f).m_85950_(r, g, b, a).m_5752_();
        }
        bufferSource.m_109911_();
        matrixStack.m_85849_();
        RenderSystem.disableDepthTest();
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        ItemStack heldItem;
        LocalPlayer player = ClientEventsHandler.mc.f_91074_;
        if (player != null && !(heldItem = player.m_21205_()).m_41619_() && heldItem.m_41720_() instanceof ItemExchangerBase) {
            ExchangerHandler.setDefaultTagCompound(heldItem);
            if (((KeyMapping)Keys.OPEN_GUI_KEY.get()).m_90857_()) {
                mc.m_91152_((Screen)new ExchangersGuiScreen());
            } else if (((KeyMapping)Keys.RANGE_SWITCH_KEY.get()).m_90857_()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketSwitchRange());
            } else if (((KeyMapping)Keys.MODE_SWITCH_KEY.get()).m_90857_()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketSwitchMode());
            } else if (((KeyMapping)Keys.FORCE_DROP_ITEMS_KEY.get()).m_90857_()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketToggleForceDropItems());
            } else if (((KeyMapping)Keys.DIRECTIONAL_PLACEMENT_KEY.get()).m_90857_()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketToggleDirectionalPlacement());
            } else if (((KeyMapping)Keys.FUZZY_PLACEMENT_KEY.get()).m_90857_()) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketToggleFuzzyPlacement());
            }
        }
    }
}

