/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.implementations.UpgradeableMenu;
import com.github.glodblock.epp.client.button.HighlightButton;
import com.github.glodblock.epp.client.button.TooltipIcon;
import com.github.glodblock.epp.client.gui.widget.WorldDisplay;
import com.github.glodblock.epp.common.me.wireless.WirelessStatus;
import com.github.glodblock.epp.container.ContainerWirelessConnector;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public class GuiWirelessConnector
extends UpgradeableScreen<ContainerWirelessConnector> {
    public static final int PADDING_X = 8;
    public static final int PADDING_Y = 6;
    private final TooltipIcon statusIcon = new TooltipIcon();
    private HighlightButton highlight;
    private final WorldDisplay remote = new WorldDisplay((AEBaseScreen<?>)this, 0, 0, 129, 63);
    private BlockPos lastPos = null;

    public GuiWirelessConnector(ContainerWirelessConnector menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
    }

    public void m_7856_() {
        super.m_7856_();
        this.statusIcon.m_264152_(this.f_97735_ + 152, this.f_97736_ + 6);
        this.remote.m_264152_(this.f_97735_ + 24, this.f_97736_ + 76);
        this.highlight = new HighlightButton();
        this.highlight.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.wireless_connect.highlight.tooltip")));
        this.highlight.m_264152_(this.f_97735_ + 152, this.f_97736_ + 6 + 18);
        this.remote.refreshBounds();
        this.m_169394_((Renderable)this.statusIcon);
        this.m_142416_((GuiEventListener)this.remote);
        this.m_142416_((GuiEventListener)this.highlight);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        if (((ContainerWirelessConnector)this.f_97732_).status == WirelessStatus.WORKING) {
            BlockPos remotePos = BlockPos.m_122022_((long)((ContainerWirelessConnector)this.f_97732_).otherSide);
            if (!Objects.equals(remotePos, this.lastPos)) {
                this.remote.locate(remotePos);
                this.lastPos = remotePos;
            }
            this.highlight.setTarget(remotePos, (ResourceKey<Level>)this.getPlayer().f_108545_.m_46472_());
            this.highlight.setMultiplier(this.playerToBlockDis(remotePos));
            this.highlight.setSuccessJob(() -> {
                if (this.getPlayer() != null) {
                    this.getPlayer().m_5661_((Component)Component.m_237110_((String)"chat.wireless.highlight", (Object[])new Object[]{remotePos.m_123344_(), this.getPlayer().m_9236_().m_46472_().m_135782_().m_135815_()}), false);
                }
            });
            this.highlight.setVisibility(true);
        } else {
            this.remote.unload();
            this.highlight.setVisibility(false);
        }
    }

    private double playerToBlockDis(BlockPos pos) {
        if (pos == null) {
            return 0.0;
        }
        BlockPos ps = this.getPlayer().m_20097_();
        return pos.m_123331_((Vec3i)ps);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int len = 12;
        this.statusIcon.m_257544_(Tooltip.m_257550_((Component)((ContainerWirelessConnector)this.f_97732_).status.getDesc()));
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.wireless_connect.status", (Object[])new Object[]{((ContainerWirelessConnector)this.f_97732_).status.getTranslation()}), 8, 6 + len, textColor, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.wireless_connect.power", (Object[])new Object[]{String.format("%.2f", ((ContainerWirelessConnector)this.f_97732_).powerUse)}), 8, 6 + len * 2, textColor, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.wireless_connect.channel", (Object[])new Object[]{((ContainerWirelessConnector)this.f_97732_).usedChannel, ((ContainerWirelessConnector)this.f_97732_).maxChannel}), 8, 6 + len * 3, textColor, false);
        if (((ContainerWirelessConnector)this.f_97732_).status == WirelessStatus.WORKING) {
            BlockPos pos = BlockPos.m_122022_((long)((ContainerWirelessConnector)this.f_97732_).otherSide);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.wireless_connect.remote", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), 22, 62, textColor, false);
        }
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.remote.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.remote.m_6050_(pMouseX, pMouseY, pDelta)) {
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }
}

