/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.client.render;

import appeng.client.render.overlay.OverlayRenderType;
import com.github.glodblock.epp.client.render.HighlightHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class HighlightRender
extends RenderType {
    public static final HighlightRender INSTANCE = new HighlightRender();

    public void tick(PoseStack stack, MultiBufferSource multiBuf, Camera camera) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        this.invalidate();
        Collection<HighlightHandler.HighlightData> drawList = HighlightHandler.getBlockData();
        if (drawList.isEmpty()) {
            return;
        }
        if ((System.currentTimeMillis() / 500L & 1L) == 0L) {
            return;
        }
        for (HighlightHandler.HighlightData block : drawList) {
            if (!block.checkDim((ResourceKey<Level>)world.m_46472_())) continue;
            this.drawBlockOutline(block.box(), stack, camera, multiBuf);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private void invalidate() {
        while (HighlightHandler.getFirst() != null) {
            HighlightHandler.HighlightData info = HighlightHandler.getFirst();
            if (System.currentTimeMillis() <= info.time()) break;
            HighlightHandler.expire();
        }
    }

    private void drawBlockOutline(AABB box, PoseStack stack, Camera camera, MultiBufferSource multiBuf) {
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 1.0f;
        if (camera.m_90593_()) {
            Vec3 vec3 = camera.m_90583_().m_82548_();
            AABB aabb = box.m_82383_(vec3);
            Vec3 topRight = new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            Vec3 bottomRight = new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
            Vec3 bottomLeft = new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82293_);
            Vec3 topLeft = new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82293_);
            Vec3 topRight2 = new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82290_);
            Vec3 bottomRight2 = new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_);
            Vec3 bottomLeft2 = new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_);
            Vec3 topLeft2 = new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_);
            VertexConsumer buf = multiBuf.m_6299_(OverlayRenderType.getBlockHilightLine());
            this.renderBox(buf, stack, topLeft, bottomLeft, topRight, bottomRight, r, g, b, a);
            this.renderBox(buf, stack, topLeft2, bottomLeft2, topRight2, bottomRight2, r, g, b, a);
            this.renderLine(buf, stack, topRight, topRight2, r, g, b, a);
            this.renderLine(buf, stack, bottomRight, bottomRight2, r, g, b, a);
            this.renderLine(buf, stack, bottomLeft, bottomLeft2, r, g, b, a);
            this.renderLine(buf, stack, topLeft, topLeft2, r, g, b, a);
        }
    }

    private void renderBox(VertexConsumer buf, PoseStack stack, Vec3 topLeft, Vec3 bottomLeft, Vec3 topRight, Vec3 bottomRight, float r, float g, float b, float a) {
        this.renderLine(buf, stack, topLeft, bottomLeft, r, g, b, a);
        this.renderLine(buf, stack, topLeft, topRight, r, g, b, a);
        this.renderLine(buf, stack, bottomRight, bottomLeft, r, g, b, a);
        this.renderLine(buf, stack, bottomRight, topRight, r, g, b, a);
    }

    private void renderLine(VertexConsumer buf, PoseStack pose, Vec3 from, Vec3 to, float r, float g, float b, float a) {
        Matrix4f mat = pose.m_85850_().m_252922_();
        Vec3 normal = from.m_82546_(to);
        buf.m_252986_(mat, (float)from.f_82479_, (float)from.f_82480_, (float)from.f_82481_).m_85950_(r, g, b, a).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        buf.m_252986_(mat, (float)to.f_82479_, (float)to.f_82480_, (float)to.f_82481_).m_85950_(r, g, b, a).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    private HighlightRender() {
        super("", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 0, false, false, () -> {}, () -> {});
    }
}

