/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.client.render.tesr;

import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.orientation.BlockOrientation;
import appeng.api.storage.cells.CellState;
import com.github.glodblock.epp.client.model.ExDriveBakedModel;
import com.github.glodblock.epp.common.tileentities.TileExDrive;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.EnumMap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ExDriveTESR
implements BlockEntityRenderer<TileExDrive> {
    public ExDriveTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileExDrive drive, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        if (drive.getCellCount() != 20) {
            throw new IllegalStateException("Expected extended drive to have 20 slots");
        }
        ms.m_85836_();
        ms.m_85837_(0.5, 0.5, 0.5);
        BlockOrientation blockOrientation = BlockOrientation.get((BlockEntity)drive);
        ms.m_252781_(blockOrientation.getQuaternion());
        ms.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer buffer = buffers.m_6299_(CellLedRenderer.RENDER_LAYER);
        Vector3f slotTranslation = new Vector3f();
        for (int disk = 0; disk < 2; ++disk) {
            for (int row = 0; row < 5; ++row) {
                for (int col = 0; col < 2; ++col) {
                    ms.m_85836_();
                    ExDriveBakedModel.getSlotOrigin(row, col, disk, slotTranslation);
                    ms.m_252880_(slotTranslation.x(), slotTranslation.y(), slotTranslation.z());
                    int slot = row * 2 + col + disk * 10;
                    CellLedRenderer.renderLed((IChestOrDrive)drive, slot, buffer, ms);
                    ms.m_85849_();
                }
            }
        }
        ms.m_85849_();
    }

    private static class CellLedRenderer {
        private static final EnumMap<CellState, Vector3f> STATE_COLORS;
        private static final Vector3f UNPOWERED_COLOR;
        private static final Vector3f BLINK_COLOR;
        private static final float L = 0.3125f;
        private static final float R = 0.25f;
        private static final float T = 0.0625f;
        private static final float B = -6.25E-5f;
        private static final float FR = -6.25E-5f;
        private static final float BA = 0.0311875f;
        private static final float[] LED_QUADS;
        public static final RenderType RENDER_LAYER;

        public static void renderLed(IChestOrDrive drive, int slot, VertexConsumer buffer, PoseStack ms) {
            Vector3f color = CellLedRenderer.getColorForSlot(drive, slot);
            if (color == null) {
                return;
            }
            for (int i = 0; i < LED_QUADS.length; i += 3) {
                float x = LED_QUADS[i];
                float y = LED_QUADS[i + 1];
                float z = LED_QUADS[i + 2];
                buffer.m_252986_(ms.m_85850_().m_252922_(), x, y, z).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
            }
        }

        private static Vector3f getColorForSlot(IChestOrDrive drive, int slot) {
            CellState state = drive.getCellStatus(slot);
            if (state == CellState.ABSENT) {
                return null;
            }
            if (!drive.isPowered()) {
                return UNPOWERED_COLOR;
            }
            Vector3f col = STATE_COLORS.get(state);
            if (drive.isCellBlinking(slot)) {
                long t = System.currentTimeMillis() % 200L;
                float f = (float)(t - 100L) / 200.0f + 0.5f;
                f = CellLedRenderer.easeInOutCubic(f);
                col = new Vector3f((Vector3fc)col);
                col.lerp((Vector3fc)BLINK_COLOR, f);
            }
            return col;
        }

        private static float easeInOutCubic(float x) {
            return x < 0.5f ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f;
        }

        private CellLedRenderer() {
        }

        static {
            UNPOWERED_COLOR = new Vector3f(0.0f, 0.0f, 0.0f);
            BLINK_COLOR = new Vector3f(1.0f, 0.5f, 0.5f);
            STATE_COLORS = new EnumMap(CellState.class);
            for (CellState cellState : CellState.values()) {
                int color = cellState.getStateColor();
                Vector3f colorVector = new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                STATE_COLORS.put(cellState, colorVector);
            }
            LED_QUADS = new float[]{0.25f, 0.0625f, -6.25E-5f, 0.3125f, 0.0625f, -6.25E-5f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.3125f, 0.0625f, -6.25E-5f, 0.3125f, 0.0625f, 0.0311875f, 0.3125f, -6.25E-5f, 0.0311875f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.25f, 0.0625f, 0.0311875f, 0.25f, 0.0625f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.25f, -6.25E-5f, 0.0311875f, 0.25f, 0.0625f, 0.0311875f, 0.3125f, 0.0625f, 0.0311875f, 0.3125f, 0.0625f, -6.25E-5f, 0.25f, 0.0625f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.3125f, -6.25E-5f, 0.0311875f, 0.25f, -6.25E-5f, 0.0311875f};
            RENDER_LAYER = RenderType.m_173215_((String)"extended_drive_leds", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)32565, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110691_(false));
        }
    }
}

