/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.blocks;

import appeng.block.crafting.PatternProviderBlock;
import appeng.block.crafting.PushDirection;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.github.glodblock.epp.common.blocks.BlockBaseGui;
import com.github.glodblock.epp.common.tileentities.TileExPatternProvider;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BlockExPatternProvider
extends BlockBaseGui<TileExPatternProvider> {
    public BlockExPatternProvider() {
        super(BlockExPatternProvider.metalProps());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)PushDirection.ALL));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PatternProviderBlock.PUSH_DIRECTION});
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        TileExPatternProvider be = (TileExPatternProvider)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            be.getLogic().updateRedstoneState();
        }
    }

    @Override
    public InteractionResult check(TileExPatternProvider tile, ItemStack stack, Level world, BlockPos pos, BlockHitResult hit, Player p) {
        if (stack != null && InteractionUtil.canWrenchRotate((ItemStack)stack)) {
            this.setSide(world, pos, hit.m_82434_());
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return null;
    }

    @Override
    public void openGui(TileExPatternProvider tile, Player p) {
        tile.openMenu(p, MenuLocators.forBlockEntity((BlockEntity)tile));
    }

    public void setSide(Level level, BlockPos pos, Direction facing) {
        BlockState currentState = level.m_8055_(pos);
        Direction pushSide = ((PushDirection)currentState.m_61143_((Property)PatternProviderBlock.PUSH_DIRECTION)).getDirection();
        PushDirection newPushDirection = pushSide == facing.m_122424_() ? PushDirection.fromDirection((Direction)facing) : (pushSide == facing ? PushDirection.ALL : (pushSide == null ? PushDirection.fromDirection((Direction)facing.m_122424_()) : PushDirection.fromDirection((Direction)Platform.rotateAround((Direction)pushSide, (Direction)facing))));
        level.m_46597_(pos, (BlockState)currentState.m_61124_((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)newPushDirection));
    }
}

