/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.blocks;

import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.github.glodblock.epp.EPP;
import com.github.glodblock.epp.common.EPPItemAndBlock;
import com.github.glodblock.epp.common.blocks.BlockBaseGui;
import com.github.glodblock.epp.common.me.wireless.WirelessFail;
import com.github.glodblock.epp.common.tileentities.TileWirelessConnector;
import com.github.glodblock.epp.config.EPPConfig;
import com.github.glodblock.epp.container.ContainerWirelessConnector;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class BlockWirelessConnector
extends BlockBaseGui<TileWirelessConnector> {
    private static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    private static final IntegerProperty COLOR = IntegerProperty.m_61631_((String)"color", (int)0, (int)16);

    public BlockWirelessConnector() {
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)COLOR, (Comparable)Integer.valueOf(16)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONNECTED});
        builder.m_61104_(new Property[]{COLOR});
    }

    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, TileWirelessConnector be) {
        return (BlockState)((BlockState)currentState.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(be.isConnected()))).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(be.getColor().ordinal()));
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        TileWirelessConnector te = (TileWirelessConnector)this.getBlockEntity((BlockGetter)level, pos);
        if (te != null) {
            te.reactive();
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() != state.m_60734_()) {
            TileWirelessConnector te = (TileWirelessConnector)this.getBlockEntity((BlockGetter)level, pos);
            if (te != null) {
                te.breakOnRemove();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public InteractionResult check(TileWirelessConnector tile, ItemStack stack, Level world, BlockPos thisPos, BlockHitResult hit, Player p) {
        if (stack.m_41720_() == EPPItemAndBlock.WIRELESS_TOOL && world instanceof ServerLevel) {
            CompoundTag nbt;
            ServerLevel server = (ServerLevel)world;
            CompoundTag compoundTag = nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
            assert (nbt != null);
            if (nbt.m_128454_("freq") != 0L) {
                long f = nbt.m_128454_("freq");
                if (!nbt.m_128441_("bind")) {
                    p.m_5661_(WirelessFail.MISSING.getTranslation(), true);
                    return InteractionResult.FAIL;
                }
                GlobalPos globalPos = GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("bind")).resultOrPartial(Util.m_137489_((String)"Connector position", arg_0 -> ((Logger)EPP.LOGGER).error(arg_0))).map(Pair::getFirst).orElse(null);
                if (globalPos == null) {
                    p.m_5661_(WirelessFail.MISSING.getTranslation(), true);
                    return InteractionResult.FAIL;
                }
                BlockPos otherPos = globalPos.m_122646_();
                ResourceKey otherWorld = globalPos.m_122640_();
                ResourceKey thisWorld = world.m_46472_();
                if (otherPos.equals((Object)thisPos) && otherWorld.equals((Object)thisWorld)) {
                    p.m_5661_(WirelessFail.SELF_REFERENCE.getTranslation(), true);
                    return InteractionResult.FAIL;
                }
                if (!otherWorld.equals((Object)thisWorld)) {
                    p.m_5661_(WirelessFail.CROSS_DIMENSION.getTranslation(), true);
                    return InteractionResult.FAIL;
                }
                if (Math.sqrt(otherPos.m_123331_((Vec3i)thisPos)) > EPPConfig.wirelessMaxRange) {
                    p.m_5661_(WirelessFail.OUT_OF_RANGE.getTranslation(), true);
                    return InteractionResult.FAIL;
                }
                ServerLevel otherWorldInstance = server.m_7654_().m_129880_(otherWorld);
                if (otherWorldInstance == null) {
                    p.m_5661_(WirelessFail.MISSING.getTranslation(), true);
                    return InteractionResult.FAIL;
                }
                BlockEntity otherTile = otherWorldInstance.m_7702_(otherPos);
                if (otherTile instanceof TileWirelessConnector) {
                    TileWirelessConnector otherConnector = (TileWirelessConnector)otherTile;
                    otherConnector.setFreq(f);
                    tile.setFreq(f);
                    stack.m_41751_(null);
                    p.m_5661_((Component)Component.m_237110_((String)"chat.wireless_connect", (Object[])new Object[]{thisPos.m_123341_(), thisPos.m_123342_(), thisPos.m_123343_()}), true);
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                p.m_5661_(WirelessFail.MISSING.getTranslation(), true);
                return InteractionResult.FAIL;
            }
            stack.m_41784_().m_128356_("freq", tile.getNewFreq());
            GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)thisPos);
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)globalPos).result().ifPresent(tag -> stack.m_41784_().m_128365_("bind", tag));
            p.m_5661_((Component)Component.m_237110_((String)"chat.wireless_bind", (Object[])new Object[]{thisPos.m_123341_(), thisPos.m_123342_(), thisPos.m_123343_()}), true);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return null;
    }

    @Override
    public void openGui(TileWirelessConnector tile, Player p) {
        MenuOpener.open(ContainerWirelessConnector.TYPE, (Player)p, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)tile));
    }
}

