/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.me;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.IGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.AELog;
import appeng.crafting.CraftingEvent;
import appeng.menu.AutoCraftingMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingThread {
    @NotNull
    private final AENetworkInvBlockEntity host;
    private final AppEngInternalInventory gridInv;
    private final InternalInventory gridInvExt;
    private final CraftingContainer craftingInv;
    private Direction pushDirection = null;
    private ItemStack myPattern = ItemStack.f_41583_;
    private IMolecularAssemblerSupportedPattern myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    private boolean forcePlan = false;
    private boolean reboot = true;
    private ItemStack output = ItemStack.f_41583_;

    public CraftingThread(@NotNull AENetworkInvBlockEntity host) {
        this.host = host;
        this.gridInv = new AppEngInternalInventory((InternalInventoryHost)this.host, 10, 1);
        this.gridInvExt = new FilteredInternalInventory((InternalInventory)this.gridInv, (IAEItemFilter)new CraftingGridFilter());
        this.craftingInv = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
    }

    public boolean isAwake() {
        return this.isAwake;
    }

    public boolean acceptJob(IPatternDetails patternDetails, KeyCounter[] table, Direction where) {
        if (this.myPattern.m_41619_() && this.gridInv.isEmpty() && patternDetails instanceof IMolecularAssemblerSupportedPattern) {
            IMolecularAssemblerSupportedPattern pattern = (IMolecularAssemblerSupportedPattern)patternDetails;
            this.forcePlan = true;
            this.myPlan = pattern;
            this.pushDirection = where;
            this.fillGrid(table, pattern);
            this.updateSleepiness();
            this.saveChanges();
            return true;
        }
        return false;
    }

    public CompoundTag writeNBT() {
        CompoundTag data = new CompoundTag();
        if (this.forcePlan) {
            ItemStack pattern;
            ItemStack itemStack = pattern = this.myPlan != null ? this.myPlan.getDefinition().toStack() : this.myPattern;
            if (!pattern.m_41619_()) {
                CompoundTag compound = new CompoundTag();
                pattern.m_41739_(compound);
                data.m_128365_("myPlan", (Tag)compound);
                data.m_128405_("pushDirection", this.pushDirection.ordinal());
            }
        }
        return data;
    }

    public void readNBT(CompoundTag data) {
        ItemStack pattern;
        this.forcePlan = false;
        this.myPattern = ItemStack.f_41583_;
        this.myPlan = null;
        if (data.m_128441_("myPlan") && !(pattern = ItemStack.m_41712_((CompoundTag)data.m_128469_("myPlan"))).m_41619_()) {
            this.forcePlan = true;
            this.myPattern = pattern;
            this.pushDirection = Direction.values()[data.m_128451_("pushDirection")];
        }
        this.recalculatePlan();
    }

    public InternalInventory getInternalInventory() {
        return this.gridInv;
    }

    public InternalInventory getExposedInventoryForSide() {
        return this.gridInvExt;
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    public TickRateModulation tick(int cards, int ticksSinceLastCall) {
        if (!this.gridInv.getStackInSlot(9).m_41619_()) {
            this.pushOut(this.gridInv.getStackInSlot(9));
            if (this.gridInv.getStackInSlot(9).m_41619_()) {
                this.saveChanges();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        switch (cards) {
            case 0: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 1.0);
                break;
            }
            case 1: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 26, 1.3);
                break;
            }
            case 2: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 34, 1.7);
                break;
            }
            case 3: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 40, 2.0);
                break;
            }
            case 4: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 2.5);
                break;
            }
            case 5: {
                this.progress += (double)this.userPower(ticksSinceLastCall, 100, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.m_6643_(); ++x) {
                this.craftingInv.m_6836_(x, this.gridInv.getStackInSlot(x));
            }
            this.progress = 0.0;
            this.output = this.myPlan.assemble((Container)this.craftingInv, this.host.m_58904_());
            if (!this.output.m_41619_()) {
                CraftingEvent.fireAutoCraftingEvent((Level)this.host.m_58904_(), (IPatternDetails)this.myPlan, (ItemStack)this.output, (Container)this.craftingInv);
                NonNullList craftingRemainders = this.myPlan.getRemainingItems(this.craftingInv);
                this.pushOut(this.output.m_41777_());
                for (int x = 0; x < this.craftingInv.m_6643_(); ++x) {
                    this.gridInv.setItemDirect(x, (ItemStack)craftingRemainders.get(x));
                }
                this.forcePlan = false;
                this.myPlan = null;
                this.pushDirection = null;
                this.ejectHeldItems();
                this.saveChanges();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
        }
        return TickRateModulation.FASTER;
    }

    public void recalculatePlan() {
        this.reboot = true;
        if (this.forcePlan) {
            if (this.host.m_58904_() != null && this.myPlan == null) {
                IPatternDetails iPatternDetails;
                if (!this.myPattern.m_41619_() && (iPatternDetails = PatternDetailsHelper.decodePattern((ItemStack)this.myPattern, (Level)this.host.m_58904_(), (boolean)false)) instanceof IMolecularAssemblerSupportedPattern) {
                    IMolecularAssemblerSupportedPattern supportedPlan;
                    this.myPlan = supportedPlan = (IMolecularAssemblerSupportedPattern)iPatternDetails;
                }
                this.myPattern = ItemStack.f_41583_;
                if (this.myPlan == null) {
                    AELog.warn((String)"Unable to restore auto-crafting pattern after load: %s", (Object[])new Object[]{this.myPattern.m_41783_()});
                    this.forcePlan = false;
                }
            }
            return;
        }
        this.progress = 0.0;
        this.myPlan = null;
        this.myPattern = ItemStack.f_41583_;
        this.pushDirection = null;
        this.updateSleepiness();
    }

    @Nullable
    public IMolecularAssemblerSupportedPattern getCurrentPattern() {
        if (this.host.isClientSide()) {
            return null;
        }
        return this.myPlan;
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        IGrid grid = this.host.getMainNode().getGrid();
        if (grid != null) {
            return (int)(grid.getEnergyService().extractAEPower((double)(ticksPassed * bonusValue) * acceleratorTax, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        return 0;
    }

    private void ejectHeldItems() {
        if (this.gridInv.getStackInSlot(9).m_41619_()) {
            for (int x = 0; x < 9; ++x) {
                ItemStack is = this.gridInv.getStackInSlot(x);
                if (is.m_41619_() || this.myPlan != null && this.myPlan.isItemValid(x, AEItemKey.of((ItemStack)is), this.host.m_58904_())) continue;
                this.gridInv.setItemDirect(9, is);
                this.gridInv.setItemDirect(x, ItemStack.f_41583_);
                this.saveChanges();
                return;
            }
        }
    }

    private void pushOut(ItemStack output) {
        if (this.pushDirection == null) {
            for (Direction d : Direction.values()) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection);
        }
        if (output.m_41619_() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setItemDirect(9, output);
    }

    private void saveChanges() {
        this.host.saveChanges();
    }

    private ItemStack pushTo(ItemStack output, Direction d) {
        int newSize;
        if (output.m_41619_()) {
            return output;
        }
        BlockEntity te = this.host.m_58904_().m_7702_(this.host.m_58899_().m_121945_(d));
        if (te == null) {
            return output;
        }
        ItemTransfer adaptor = InternalInventory.wrapExternal((BlockEntity)te, (Direction)d.m_122424_());
        if (adaptor == null) {
            return output;
        }
        int size = output.m_41613_();
        int n = newSize = (output = adaptor.addItems(output)).m_41619_() ? 0 : output.m_41613_();
        if (size != newSize) {
            this.saveChanges();
        }
        return output;
    }

    private void fillGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern adapter) {
        adapter.fillCraftingGrid(table, (arg_0, arg_1) -> ((AppEngInternalInventory)this.gridInv).setItemDirect(arg_0, arg_1));
        for (KeyCounter list : table) {
            list.removeZeros();
            if (list.isEmpty()) continue;
            throw new RuntimeException("Could not fill grid with some items, including " + list.iterator().next());
        }
    }

    public void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            this.host.getMainNode().ifPresent((grid, node) -> {
                if (this.isAwake) {
                    grid.getTickManager().wakeDevice(node);
                } else {
                    grid.getTickManager().sleepDevice(node);
                }
            });
        }
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.m_6643_(); ++x) {
            this.craftingInv.m_6836_(x, this.gridInv.getStackInSlot(x));
        }
        return !this.myPlan.assemble((Container)this.craftingInv, this.host.m_58904_()).m_41619_();
    }

    private boolean canPush() {
        return !this.gridInv.getStackInSlot(9).m_41619_();
    }

    public ItemStack getOutput() {
        return this.output;
    }

    private static class CraftingGridFilter
    implements IAEItemFilter {
        private CraftingGridFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return slot == 9;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return false;
        }
    }
}

