/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.common.me.wireless;

import appeng.api.features.Locatables;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.me.service.helpers.ConnectionWrapper;
import com.github.glodblock.epp.EPP;
import com.github.glodblock.epp.common.tileentities.TileWirelessConnector;
import com.github.glodblock.epp.config.EPPConfig;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class WirelessConnect
implements IActionHost {
    private static final Locatables.Type<IActionHost> CONNECTORS = new Locatables.Type();
    private boolean isDestroyed = false;
    private boolean registered;
    private ConnectionWrapper connection;
    private long thisSide;
    private long otherSide;
    private boolean shutdown;
    private double dis;
    private TileWirelessConnector host;

    public WirelessConnect(TileWirelessConnector connector) {
        this.host = connector;
        this.registered = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onUnload(LevelEvent.Unload e) {
        if (this.host != null && this.host.m_58904_() == e.getLevel()) {
            this.destroy();
        }
    }

    public void active() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registered = true;
    }

    public void updateStatus() {
        long f = this.host.getFrequency();
        if (this.thisSide != f && this.thisSide != -f) {
            if (f != 0L) {
                if (this.thisSide != 0L) {
                    CONNECTORS.unregister(this.host.m_58904_(), this.thisSide);
                }
                if (this.canUseNode(-f)) {
                    this.otherSide = f;
                    this.thisSide = -f;
                } else if (this.canUseNode(f)) {
                    this.thisSide = f;
                    this.otherSide = -f;
                }
                CONNECTORS.register(this.host.m_58904_(), this.getLocatableKey(), (Object)this);
            } else {
                CONNECTORS.unregister(this.host.m_58904_(), this.getLocatableKey());
                this.otherSide = 0L;
                this.thisSide = 0L;
            }
        }
        IActionHost myOtherSide = this.otherSide == 0L ? null : (IActionHost)CONNECTORS.get(this.host.m_58904_(), this.otherSide);
        this.shutdown = false;
        this.dis = 0.0;
        if (myOtherSide instanceof WirelessConnect) {
            WirelessConnect sideB = (WirelessConnect)myOtherSide;
            WirelessConnect sideA = this;
            this.dis = Math.sqrt(sideA.host.m_58899_().m_123331_((Vec3i)sideB.host.m_58899_()));
            if (sideA.isActive() && sideB.isActive() && this.dis <= EPPConfig.wirelessMaxRange && sideA.host.m_58904_() == sideB.host.m_58904_()) {
                if (this.connection != null && this.connection.getConnection() != null) {
                    IGridNode a = this.connection.getConnection().a();
                    IGridNode b = this.connection.getConnection().b();
                    IGridNode sa = sideA.getNode();
                    IGridNode sb = sideB.getNode();
                    if (!(a != sa && b != sa || a != sb && b != sb)) {
                        return;
                    }
                }
                try {
                    if (sideA.connection != null && sideA.connection.getConnection() != null) {
                        sideA.connection.getConnection().destroy();
                        sideA.connection = new ConnectionWrapper(null);
                    }
                    if (sideB.connection != null && sideB.connection.getConnection() != null) {
                        sideB.connection.getConnection().destroy();
                        sideB.connection = new ConnectionWrapper(null);
                    }
                    if (sideA.getNode() != null && sideB.getNode() != null) {
                        sideA.connection = sideB.connection = new ConnectionWrapper(GridHelper.createConnection((IGridNode)sideA.getNode(), (IGridNode)sideB.getNode()));
                    }
                }
                catch (IllegalStateException e) {
                    EPP.LOGGER.debug(e.getMessage());
                }
            } else {
                this.shutdown = true;
            }
        } else {
            this.shutdown = true;
        }
        if (this.shutdown && this.connection != null && this.connection.getConnection() != null) {
            this.connection.getConnection().destroy();
            this.connection.setConnection(null);
            this.connection = new ConnectionWrapper(null);
        }
    }

    public double getDistance() {
        return this.dis;
    }

    public boolean isConnected() {
        return !this.shutdown;
    }

    private boolean canUseNode(long qe) {
        IActionHost locatable = (IActionHost)CONNECTORS.get(this.host.m_58904_(), qe);
        if (locatable instanceof WirelessConnect) {
            WirelessConnect qc = (WirelessConnect)locatable;
            Level world = qc.host.m_58904_();
            if (!qc.isDestroyed && world != null) {
                if (world.m_46805_(qc.host.m_58899_())) {
                    ServerLevel cur = Objects.requireNonNull(world.m_7654_()).m_129880_(world.m_46472_());
                    BlockEntity te = world.m_7702_(qc.host.m_58899_());
                    return te != qc.host || world != cur;
                }
                EPP.LOGGER.warn(String.format("Found a registered Wireless Connector with serial %s whose chunk seems to be unloaded: %s", qe, qc));
            }
        }
        return true;
    }

    @Nullable
    public BlockPos getOtherSide() {
        BlockPos blockPos;
        if (this.otherSide == 0L) {
            return null;
        }
        IActionHost o = (IActionHost)CONNECTORS.get(this.host.m_58904_(), this.otherSide);
        if (o instanceof WirelessConnect) {
            WirelessConnect c = (WirelessConnect)o;
            blockPos = c.host.m_58899_();
        } else {
            blockPos = null;
        }
        return blockPos;
    }

    private boolean isActive() {
        if (this.isDestroyed || !this.registered) {
            return false;
        }
        return this.hasFreq();
    }

    private IGridNode getNode() {
        return this.host.getGridNode();
    }

    private boolean hasFreq() {
        return this.thisSide != 0L;
    }

    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        try {
            if (this.registered) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                this.registered = false;
            }
            if (this.thisSide != 0L) {
                this.updateStatus();
                CONNECTORS.unregister(this.host.m_58904_(), this.getLocatableKey());
            }
            this.host = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long getLocatableKey() {
        return this.thisSide;
    }

    public IGridNode getActionableNode() {
        return this.host.getMainNode().getNode();
    }
}

