/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.container;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import com.github.glodblock.epp.common.parts.PartTagStorageBus;
import com.github.glodblock.epp.network.EPPNetworkHandler;
import com.github.glodblock.epp.network.packet.SGenericPacket;
import com.github.glodblock.epp.network.packet.sync.IActionHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerTagStorageBus
extends UpgradeableMenu<PartTagStorageBus>
implements IActionHolder {
    private final Map<String, Consumer<Object[]>> actions = new Object2ObjectOpenHashMap();
    private static final String ACTION_PARTITION = "partition";
    public static final MenuType<ContainerTagStorageBus> TYPE = MenuTypeBuilder.create(ContainerTagStorageBus::new, PartTagStorageBus.class).build("tag_storage_bus");
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;
    @GuiSync(value=7)
    public YesNo filterOnExtract = YesNo.YES;
    @GuiSync(value=8)
    @Nullable
    public Component connectedTo;
    @GuiSync(value=9)
    public String exp = "";

    public ContainerTagStorageBus(int id, Inventory ip, PartTagStorageBus te) {
        super(TYPE, id, ip, (IUpgradeableObject)te);
        this.registerClientAction(ACTION_PARTITION, this::partition);
        this.actions.put("set", o -> this.setExp((String)o[0]));
        this.actions.put("update", o -> {
            Player patt2212$temp = this.getPlayer();
            if (patt2212$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt2212$temp;
                EPPNetworkHandler.INSTANCE.sendTo(new SGenericPacket("init", this.exp), sp);
            }
        });
        this.connectedTo = te.getConnectedToDescription();
    }

    protected void setupConfig() {
    }

    public void m_38946_() {
        super.m_38946_();
        this.connectedTo = ((PartTagStorageBus)this.getHost()).getConnectedToDescription();
        if (!this.exp.equals(((PartTagStorageBus)this.getHost()).getTagFilter())) {
            this.exp = ((PartTagStorageBus)this.getHost()).getTagFilter();
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setReadWriteMode((AccessRestriction)cm.getSetting(Settings.ACCESS));
        this.setStorageFilter((StorageFilter)cm.getSetting(Settings.STORAGE_FILTER));
        this.setFilterOnExtract((YesNo)cm.getSetting(Settings.FILTER_ON_EXTRACT));
    }

    public boolean isSlotEnabled(int idx) {
        return false;
    }

    public void partition() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_PARTITION);
            return;
        }
        this.m_38946_();
    }

    public void setExp(String exp) {
        ((PartTagStorageBus)this.getHost()).setTagFilter(exp);
        this.m_38946_();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    public YesNo getFilterOnExtract() {
        return this.filterOnExtract;
    }

    public void setFilterOnExtract(YesNo filterOnExtract) {
        this.filterOnExtract = filterOnExtract;
    }

    @Nullable
    public Component getConnectedTo() {
        return this.connectedTo;
    }

    @Override
    @NotNull
    public Map<String, Consumer<Object[]>> getActionMap() {
        return this.actions;
    }
}

