/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.network.packet;

import appeng.crafting.pattern.CraftingPatternItem;
import appeng.crafting.pattern.ProcessingPatternItem;
import appeng.crafting.pattern.SmithingTablePatternItem;
import appeng.crafting.pattern.StonecuttingPatternItem;
import com.github.glodblock.epp.container.pattern.ContainerCraftingPattern;
import com.github.glodblock.epp.container.pattern.ContainerProcessingPattern;
import com.github.glodblock.epp.container.pattern.ContainerSmithingTablePattern;
import com.github.glodblock.epp.container.pattern.ContainerStonecuttingPattern;
import com.github.glodblock.epp.container.pattern.PatternGuiHandler;
import com.github.glodblock.epp.network.packet.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CPatternKey
implements IMessage<CPatternKey> {
    private ItemStack pattern;
    private static long nextWarning = -1L;

    public CPatternKey() {
    }

    public CPatternKey(ItemStack stack) {
        this.pattern = stack;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeItemStack(this.pattern, false);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.pattern = buf.m_130267_();
    }

    @Override
    public void onMessage(Player player) {
        if (this.pattern.m_41720_() instanceof ProcessingPatternItem) {
            PatternGuiHandler.open(player, ContainerProcessingPattern.ID.toString(), this.pattern);
        } else if (this.pattern.m_41720_() instanceof CraftingPatternItem) {
            PatternGuiHandler.open(player, ContainerCraftingPattern.ID.toString(), this.pattern);
        } else if (this.pattern.m_41720_() instanceof StonecuttingPatternItem) {
            PatternGuiHandler.open(player, ContainerStonecuttingPattern.ID.toString(), this.pattern);
        } else if (this.pattern.m_41720_() instanceof SmithingTablePatternItem) {
            PatternGuiHandler.open(player, ContainerSmithingTablePattern.ID.toString(), this.pattern);
        } else if (nextWarning < System.currentTimeMillis()) {
            nextWarning = System.currentTimeMillis() + 2000L;
            player.m_213846_((Component)Component.m_237110_((String)"chat.pattern_view.error", (Object[])new Object[]{"https://github.com/GlodBlock/ExtendedAE/issues"}));
        }
    }

    @Override
    public Class<CPatternKey> getPacketClass() {
        return CPatternKey.class;
    }

    @Override
    public boolean isClient() {
        return false;
    }
}

