/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.network.packet;

import com.github.glodblock.epp.client.gui.GuiExPatternTerminal;
import com.github.glodblock.epp.network.packet.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SExPatternInfo
implements IMessage<SExPatternInfo> {
    private long id;
    private BlockPos pos;
    private ResourceKey<Level> dim;
    @Nullable
    private Direction face;

    public SExPatternInfo() {
    }

    public SExPatternInfo(long id, BlockPos pos, ResourceKey<Level> dim, @Nullable Direction face) {
        this.id = id;
        this.pos = pos;
        this.dim = dim;
        this.face = face;
    }

    public SExPatternInfo(long id, BlockPos pos, ResourceKey<Level> dim) {
        this(id, pos, dim, null);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130103_(this.id);
        buf.m_130103_(this.pos.m_121878_());
        buf.m_236858_(this.dim);
        if (this.face == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130068_((Enum)this.face);
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.id = buf.m_130258_();
        this.pos = BlockPos.m_122022_((long)buf.m_130258_());
        this.dim = buf.m_236801_(Registries.f_256858_);
        if (buf.readBoolean()) {
            this.face = (Direction)buf.m_130066_(Direction.class);
        }
    }

    @Override
    public void onMessage(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof GuiExPatternTerminal) {
            GuiExPatternTerminal gui = (GuiExPatternTerminal)screen;
            gui.postTileInfo(this.id, this.pos, this.dim, this.face);
        }
    }

    @Override
    public Class<SExPatternInfo> getPacketClass() {
        return SExPatternInfo.class;
    }

    @Override
    public boolean isClient() {
        return true;
    }
}

