/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.taglist;

import appeng.api.stacks.AEKey;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TagPriorityList
implements IPartitionList {
    private final Set<TagKey<?>> whiteSet;
    private final Set<TagKey<?>> blackSet;
    private final String tagExp;
    private final LoadingCache<Object, Boolean> accept = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(4000L).build((CacheLoader)new CacheLoader<Object, Boolean>(){

        @NotNull
        public Boolean load(@NotNull Object obj) {
            Holder refer = null;
            if (obj instanceof Item) {
                Item item = (Item)obj;
                refer = ForgeRegistries.ITEMS.getHolder((Object)item).orElse(null);
            } else if (obj instanceof Fluid) {
                Fluid fluid = (Fluid)obj;
                refer = ForgeRegistries.FLUIDS.getHolder((Object)fluid).orElse(null);
            }
            if (refer != null) {
                if (TagPriorityList.this.whiteSet.isEmpty()) {
                    return false;
                }
                boolean pass = refer.m_203616_().anyMatch(TagPriorityList.this.whiteSet::contains);
                if (pass) {
                    if (!TagPriorityList.this.blackSet.isEmpty()) {
                        return refer.m_203616_().noneMatch(TagPriorityList.this.blackSet::contains);
                    }
                    return true;
                }
            }
            return false;
        }
    });

    public TagPriorityList(Set<TagKey<?>> whiteKeys, Set<TagKey<?>> blackKeys, String tagExp) {
        this.whiteSet = whiteKeys;
        this.blackSet = blackKeys;
        this.tagExp = tagExp;
    }

    public boolean isListed(AEKey input) {
        return (Boolean)this.accept.getUnchecked(input.getPrimaryKey());
    }

    public boolean isEmpty() {
        return this.tagExp.isEmpty();
    }

    public Iterable<AEKey> getItems() {
        return List.of();
    }
}

