/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage;

import com.mojang.logging.LogUtils;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import edivad.extrastorage.blockentity.AdvancedCrafterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedExporterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedFluidStorageBlockEntity;
import edivad.extrastorage.blockentity.AdvancedImporterBlockEntity;
import edivad.extrastorage.blockentity.AdvancedStorageBlockEntity;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.compat.TOPIntegration;
import edivad.extrastorage.data.ExtraStorageBlockTagsProvider;
import edivad.extrastorage.data.ExtraStorageItemTagsProvider;
import edivad.extrastorage.data.ExtraStorageLanguageProvider;
import edivad.extrastorage.data.ExtraStorageRecipeProvider;
import edivad.extrastorage.data.loot.pack.ExtraStorageLootTableProvider;
import edivad.extrastorage.data.models.ExtraStorageBlockModelProvider;
import edivad.extrastorage.data.models.ExtraStorageItemModelProvider;
import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import edivad.extrastorage.items.storage.item.ItemStorageType;
import edivad.extrastorage.nodes.AdvancedCrafterNetworkNode;
import edivad.extrastorage.nodes.AdvancedExporterNetworkNode;
import edivad.extrastorage.nodes.AdvancedFluidStorageNetworkNode;
import edivad.extrastorage.nodes.AdvancedImporterNetworkNode;
import edivad.extrastorage.nodes.AdvancedStorageNetworkNode;
import edivad.extrastorage.setup.ClientSetup;
import edivad.extrastorage.setup.Config;
import edivad.extrastorage.setup.CreativeModeTabs;
import edivad.extrastorage.setup.ESBlockEntities;
import edivad.extrastorage.setup.ESBlocks;
import edivad.extrastorage.setup.ESContainer;
import edivad.extrastorage.setup.ESItems;
import edivad.extrastorage.setup.ESLootFunctions;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="extrastorage")
public class ExtraStorage {
    public static final String ID = "extrastorage";
    public static final String MODNAME = "ExtraStorage";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ExtraStorage() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(ClientSetup::init);
            modEventBus.addListener(ClientSetup::onModelBake);
        }
        ESBlocks.register(modEventBus);
        ESItems.register(modEventBus);
        ESBlockEntities.register(modEventBus);
        ESContainer.register(modEventBus);
        CreativeModeTabs.register(modEventBus);
        Config.init();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleGatherData);
        modEventBus.addListener(this::onRegister);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(ID, path);
    }

    private static INetworkNode readAndReturn(CompoundTag tag, NetworkNode node) {
        node.read(tag);
        return node;
    }

    private void onRegister(RegisterEvent e) {
        e.register(Registries.f_257015_, helper -> ESLootFunctions.register());
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ExtraStorageBlockTagsProvider blockTags = new ExtraStorageBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        CompletableFuture blockTagsLookup = blockTags.m_274426_();
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraStorageItemTagsProvider(packOutput, lookupProvider, blockTagsLookup, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraStorageLootTableProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraStorageRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraStorageLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraStorageBlockModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraStorageItemModelProvider(packOutput, existingFileHelper));
    }

    public void handleCommonSetup(FMLCommonSetupEvent event) {
        for (CrafterTier crafterTier : CrafterTier.values()) {
            API.instance().getNetworkNodeRegistry().add(ExtraStorage.rl(crafterTier.getID()), (tag, world, pos) -> ExtraStorage.readAndReturn(tag, new AdvancedCrafterNetworkNode(world, pos, tier)));
            ((AdvancedCrafterBlockEntity)((BlockEntityType)ESBlockEntities.CRAFTER.get((Object)crafterTier).get()).m_155264_(BlockPos.f_121853_, null)).getDataManager().getParameters().forEach(BlockEntitySynchronizationManager::registerParameter);
        }
        for (Enum enum_ : ItemStorageType.values()) {
            API.instance().getNetworkNodeRegistry().add(ExtraStorage.rl("block_" + ((ItemStorageType)enum_).getName()), (arg_0, arg_1, arg_2) -> ExtraStorage.lambda$handleCommonSetup$2((ItemStorageType)enum_, arg_0, arg_1, arg_2));
            ((AdvancedStorageBlockEntity)((BlockEntityType)ESBlockEntities.ITEM_STORAGE.get(enum_).get()).m_155264_(BlockPos.f_121853_, null)).getDataManager().getParameters().forEach(BlockEntitySynchronizationManager::registerParameter);
        }
        for (Enum enum_ : FluidStorageType.values()) {
            API.instance().getNetworkNodeRegistry().add(ExtraStorage.rl("block_" + ((FluidStorageType)enum_).getName() + "_fluid"), (arg_0, arg_1, arg_2) -> ExtraStorage.lambda$handleCommonSetup$3((FluidStorageType)enum_, arg_0, arg_1, arg_2));
            ((AdvancedFluidStorageBlockEntity)((BlockEntityType)ESBlockEntities.FLUID_STORAGE.get(enum_).get()).m_155264_(BlockPos.f_121853_, null)).getDataManager().getParameters().forEach(BlockEntitySynchronizationManager::registerParameter);
        }
        API.instance().getNetworkNodeRegistry().add(AdvancedExporterNetworkNode.ID, (tag, world, pos) -> ExtraStorage.readAndReturn(tag, new AdvancedExporterNetworkNode(world, pos)));
        API.instance().getNetworkNodeRegistry().add(AdvancedImporterNetworkNode.ID, (tag, world, pos) -> ExtraStorage.readAndReturn(tag, new AdvancedImporterNetworkNode(world, pos)));
        ((AdvancedExporterBlockEntity)((BlockEntityType)ESBlockEntities.ADVANCED_EXPORTER.get()).m_155264_(BlockPos.f_121853_, null)).getDataManager().getParameters().forEach(BlockEntitySynchronizationManager::registerParameter);
        ((AdvancedImporterBlockEntity)((BlockEntityType)ESBlockEntities.ADVANCED_IMPORTER.get()).m_155264_(BlockPos.f_121853_, null)).getDataManager().getParameters().forEach(BlockEntitySynchronizationManager::registerParameter);
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPIntegration::new);
        }
        if (ModList.get().isLoaded("inventorysorter")) {
            ESContainer.CRAFTER.values().forEach(v -> InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ((RegistryObject)v).getId()));
            ESContainer.ITEM_STORAGE.values().forEach(v -> InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ((RegistryObject)v).getId()));
            ESContainer.FLUID_STORAGE.values().forEach(v -> InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ((RegistryObject)v).getId()));
            InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ESContainer.ADVANCED_EXPORTER.getId());
            InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ESContainer.ADVANCED_IMPORTER.getId());
        }
    }

    private static /* synthetic */ INetworkNode lambda$handleCommonSetup$3(FluidStorageType type, CompoundTag tag, Level world, BlockPos pos) {
        return ExtraStorage.readAndReturn(tag, (NetworkNode)new AdvancedFluidStorageNetworkNode(world, pos, type));
    }

    private static /* synthetic */ INetworkNode lambda$handleCommonSetup$2(ItemStorageType type, CompoundTag tag, Level world, BlockPos pos) {
        return ExtraStorage.readAndReturn(tag, (NetworkNode)new AdvancedStorageNetworkNode(world, pos, type));
    }
}

