/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.items.storage;

import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ExpandedStorageDisk
extends Item
implements IStorageDiskProvider {
    private static final String ID = "ID";

    public ExpandedStorageDisk() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (!level.f_46443_ && !stack.m_41782_() && entity instanceof Player) {
            Player player = (Player)entity;
            UUID id = UUID.randomUUID();
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getType() == StorageType.ITEM) {
                API.instance().getStorageDiskManager(serverLevel).set(id, API.instance().createDefaultItemDisk(serverLevel, this.getCapacity(stack), player));
            } else if (this.getType() == StorageType.FLUID) {
                API.instance().getStorageDiskManager(serverLevel).set(id, API.instance().createDefaultFluidDisk(serverLevel, this.getCapacity(stack), player));
            }
            API.instance().getStorageDiskManager(serverLevel).markForSaving();
            this.setId(stack, id);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack diskStack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_()) {
            ServerLevel serverLevel = (ServerLevel)level;
            IStorageDisk disk = API.instance().getStorageDiskManager(serverLevel).getByStack(diskStack);
            if (disk != null && disk.getStored() == 0) {
                ItemStack part = new ItemStack((ItemLike)this.getPart(), diskStack.m_41613_());
                if (!player.m_150109_().m_36054_(part.m_41777_())) {
                    Containers.m_18992_((Level)level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)part);
                }
                API.instance().getStorageDiskManager(serverLevel).remove(this.getId(diskStack));
                API.instance().getStorageDiskManager(serverLevel).markForSaving();
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)new ItemStack((ItemLike)RSItems.STORAGE_HOUSING.get()));
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)diskStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.storage.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}).m_6270_(Styles.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"misc.refinedstorage.storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}).m_6270_(Styles.GRAY));
                }
            }
            if (flag.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)id.toString()).m_6270_(Styles.GRAY));
            }
        }
    }

    public int getEntityLifespan(ItemStack stack, Level level) {
        return Integer.MAX_VALUE;
    }

    public UUID getId(ItemStack disk) {
        return disk.m_41783_().m_128342_(ID);
    }

    public void setId(ItemStack disk, UUID id) {
        disk.m_41784_().m_128362_(ID, id);
    }

    public boolean isValid(ItemStack disk) {
        return disk.m_41782_() && disk.m_41783_().m_128403_(ID);
    }

    protected abstract Item getPart();
}

