/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.fluid;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.Reactants;
import it.zerono.mods.zerocore.lib.fluid.SimpleFluidTypeRenderProperties;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class ReactorFluidType
extends FluidType {
    private final int _tintColour;

    public static ReactorFluidType of(String registrationName, int tint, int density, int lightLevel, Rarity rarity) {
        return new ReactorFluidType(registrationName, 0xFF000000 | tint, density, lightLevel, rarity);
    }

    public static ReactorFluidType of(Reactants reactant) {
        return ReactorFluidType.of(reactant.getReactantName(), reactant.getColour(), reactant.getFluidDensity(), reactant.getFluidLightLevel(), reactant.getRarity());
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept((IClientFluidTypeExtensions)new RenderProperties());
    }

    private ReactorFluidType(String registrationName, int tint, int density, int lightLevel, Rarity rarity) {
        super(FluidType.Properties.create().descriptionId("fluid.bigreactors." + registrationName).density(density).lightLevel(lightLevel).canDrown(true).canSwim(true).canPushEntity(true).fallDistanceModifier(0.4f).canExtinguish(false).canConvertToSource(false).supportsBoating(true).pathType(BlockPathTypes.WATER).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canHydrate(false).rarity(rarity));
        this._tintColour = tint;
    }

    private class RenderProperties
    extends SimpleFluidTypeRenderProperties {
        public RenderProperties() {
            super(0, CommonConstants.FLUID_TEXTURE_SOURCE_WATER, CommonConstants.FLUID_TEXTURE_FLOWING_WATER, CommonConstants.FLUID_TEXTURE_OVERLAY_WATER);
        }

        public int getTintColor() {
            return ReactorFluidType.this._tintColour;
        }
    }
}

