/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.zerono.mods.extremereactors.gamecontent.multiblock.IMachineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.AbstractSensorSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.ISensorSettingFactory;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.ISensorType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.client.gui.control.ChoiceText;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.PanelGroup;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.control.TextInput;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;

public class RedstonePortSettingControlsMap<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType>> {
    public final Label SensorName;
    public final PanelGroup<SensorType> SensorsGroup;
    public final Map<SensorType, SensorEntry> Sensors;
    private final ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> _factory;

    public RedstonePortSettingControlsMap(Label name, PanelGroup<SensorType> group, ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> factory) {
        this.SensorName = name;
        this.SensorsGroup = group;
        this.Sensors = Maps.newHashMap();
        this._factory = factory;
    }

    public void add(SensorType sensor, SensorEntry entry) {
        this.Sensors.put(sensor, entry);
    }

    public SensorSetting getSettings(SensorSetting defaultValue) {
        return (SensorSetting)this.SensorsGroup.getActivePanelIndex().filter(sensor -> !((ISensorType)((Object)sensor)).isDisabled()).map(x$0 -> this.createSetting((Enum)x$0)).orElse((AbstractSensorSetting)defaultValue);
    }

    public void setSettings(SensorSetting setting) {
        this.resetControls();
        if (!((ISensorType)((Object)((Enum)((AbstractSensorSetting)setting).Sensor))).isDisabled()) {
            SensorEntry se = this.Sensors.get(((AbstractSensorSetting)setting).Sensor);
            List<TextInput> inputs = se.inputs(((AbstractSensorSetting)setting).Behavior);
            int[] values = new int[]{((AbstractSensorSetting)setting).Value1, ((AbstractSensorSetting)setting).Value2};
            for (int idx = 0; idx < Math.min(values.length, inputs.size()); ++idx) {
                inputs.get(idx).setText(Integer.toString(values[idx]));
            }
            se.SensorControl.setActive(true);
            se.BehaviorControl.setSelectedIndex((Enum)((AbstractSensorSetting)setting).Behavior);
            this.SensorName.setText((Component)Component.m_237115_((String)(((ISensorType)((Object)((Enum)((AbstractSensorSetting)setting).Sensor))).getTranslationBaseName() + "1")));
            this.SensorsGroup.setActivePanel((Enum)((AbstractSensorSetting)setting).Sensor);
        }
    }

    private void resetControls() {
        this.SensorName.setText("");
        this.SensorsGroup.clearActivePanel();
        this.Sensors.values().forEach(se -> {
            se.SensorControl.setActive(false);
            se.BehaviorControl.setSelectedIndex((Enum)((SensorBehavior)((Object)((Object)se.BehaviorControl.getValidIndices().get(0)))));
            se.Behaviors.values().forEach(be -> be.Inputs.forEach(i -> i.setText("0")));
        });
    }

    private SensorSetting createSetting(SensorType sensor) {
        SensorEntry se = this.Sensors.get(sensor);
        SensorBehavior behavior = (SensorBehavior)se.BehaviorControl.getSelectedIndex();
        List<TextInput> inputs = se.inputs(behavior);
        int[] values = new int[2];
        for (int idx = 0; idx < Math.min(values.length, inputs.size()); ++idx) {
            values[idx] = inputs.get(idx).intValue();
        }
        return this._factory.create(sensor, behavior, values[0], values[1]);
    }

    public static class SensorEntry {
        public final SwitchPictureButton SensorControl;
        public final ChoiceText<SensorBehavior> BehaviorControl;
        public final Map<SensorBehavior, BehaviorEntry> Behaviors;

        public SensorEntry(SwitchPictureButton sensorControl, ChoiceText<SensorBehavior> behaviorControl, BehaviorEntry ... behaviors) {
            this.SensorControl = sensorControl;
            this.BehaviorControl = behaviorControl;
            this.Behaviors = (Map)Arrays.stream(behaviors).collect(ImmutableMap.toImmutableMap(be -> be.Behavior, be -> be));
        }

        public SensorEntry(SwitchPictureButton sensorControl, ChoiceText<SensorBehavior> behaviorControl, List<BehaviorEntry> behaviors) {
            this.SensorControl = sensorControl;
            this.BehaviorControl = behaviorControl;
            this.Behaviors = (Map)behaviors.stream().collect(ImmutableMap.toImmutableMap(be -> be.Behavior, be -> be));
        }

        public List<TextInput> inputs(SensorBehavior behavior) {
            return this.Behaviors.containsKey((Object)behavior) ? this.Behaviors.get((Object)((Object)behavior)).Inputs : Collections.emptyList();
        }
    }

    public static class BehaviorEntry {
        public final SensorBehavior Behavior;
        public final List<TextInput> Inputs;

        public BehaviorEntry(SensorBehavior behavior, TextInput ... inputs) {
            this.Behavior = behavior;
            this.Inputs = ImmutableList.copyOf((Object[])inputs);
        }
    }
}

