/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.computer;

import com.google.common.collect.Maps;
import it.zerono.mods.extremereactors.gamecontent.multiblock.IMachineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorComputerPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControlRodEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.LuaHelper;
import it.zerono.mods.zerocore.lib.compat.computer.MultiblockComputerPeripheral;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullConsumer;

public class ReactorComputerPeripheral
extends MultiblockComputerPeripheral<MultiblockReactor, ReactorComputerPortEntity> {
    public ReactorComputerPeripheral(ReactorComputerPortEntity reactorComputerPort) {
        super((AbstractMultiblockPart)reactorComputerPort);
    }

    public String getPeripheralStaticName() {
        return "extremereactor-reactorComputerPort";
    }

    public void populateMethods(NonNullConsumer<ComputerMethod<MultiblockComputerPeripheral<MultiblockReactor, ReactorComputerPortEntity>>> methodConsumer) {
        super.populateMethods(methodConsumer);
        methodConsumer.accept((Object)new ComputerMethod("getVariant", this.wrapControllerValue(c -> c.getVariant().getName())));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyStored", this.wrapControllerValue(c -> c.getEnergyStored(c.getOutputEnergySystem()).doubleValue())));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyStoredAsText", this.wrapControllerValue(c -> {
            EnergySystem sys = c.getOutputEnergySystem();
            return CodeHelper.formatAsHumanReadableNumber((double)c.getEnergyStored(sys).doubleValue(), (String)sys.getUnit());
        })));
        methodConsumer.accept((Object)new ComputerMethod("getNumberOfControlRods", this.wrapControllerValue(IReactorReader::getControlRodsCount)));
        methodConsumer.accept((Object)new ComputerMethod("getActive", this.wrapControllerValue(IMachineReader::isMachineActive)));
        methodConsumer.accept((Object)new ComputerMethod("getFuelTemperature", this.wrapControllerValue(c -> c.getFuelHeatValue().getAsDouble())));
        methodConsumer.accept((Object)new ComputerMethod("getCasingTemperature", this.wrapControllerValue(c -> c.getReactorHeatValue().getAsDouble())));
        methodConsumer.accept((Object)new ComputerMethod("getFuelAmount", this.wrapControllerValue(IReactorReader::getFuelAmount)));
        methodConsumer.accept((Object)new ComputerMethod("getWasteAmount", this.wrapControllerValue(IReactorReader::getWasteAmount)));
        methodConsumer.accept((Object)new ComputerMethod("getFuelAmountMax", this.wrapControllerValue(c -> c.getCapacity())));
        methodConsumer.accept((Object)new ComputerMethod("getControlRodName", this.wrapControllerValue(ReactorComputerPeripheral.controlRodByIndex(ReactorControlRodEntity::getName)), 1));
        methodConsumer.accept((Object)new ComputerMethod("getControlRodLevel", this.wrapControllerValue(ReactorComputerPeripheral.controlRodByIndex(ReactorControlRodEntity::getInsertionRatio)), 1));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyProducedLastTick", this.wrapControllerValue(c -> c.getOperationalMode().isPassive() ? c.getUiStats().getAmountGeneratedLastTick() : 0.0)));
        methodConsumer.accept((Object)new ComputerMethod("getHotFluidProducedLastTick", this.wrapControllerValue(c -> c.getOperationalMode().isActive() ? c.getUiStats().getAmountGeneratedLastTick() : 0.0)));
        methodConsumer.accept((Object)new ComputerMethod("isActivelyCooled", this.wrapControllerValue(c -> c.getOperationalMode().isActive())));
        methodConsumer.accept((Object)new ComputerMethod("getCoolantAmount", this.wrapControllerValue(c -> c.getFluidContainer().getLiquidAmount())));
        methodConsumer.accept((Object)new ComputerMethod("getCoolantAmountMax", this.wrapControllerValue(c -> c.getFluidContainer().getCapacity())));
        methodConsumer.accept((Object)new ComputerMethod("getCoolantType", this.wrapControllerValue(c -> c.getFluidContainer().getLiquid().map(f -> CodeHelper.getObjectId((Fluid)f).toString()))));
        methodConsumer.accept((Object)new ComputerMethod("getHotFluidAmount", this.wrapControllerValue(c -> c.getFluidContainer().getGasAmount())));
        methodConsumer.accept((Object)new ComputerMethod("getHotFluidAmountMax", this.wrapControllerValue(c -> c.getFluidContainer().getCapacity())));
        methodConsumer.accept((Object)new ComputerMethod("getHotFluidType", this.wrapControllerValue(c -> c.getFluidContainer().getGas().map(f -> CodeHelper.getObjectId((Fluid)f).toString()))));
        methodConsumer.accept((Object)new ComputerMethod("getFuelReactivity", this.wrapControllerValue(c -> Float.valueOf(c.getFuelFertility() * 100.0f))));
        methodConsumer.accept((Object)new ComputerMethod("getFuelConsumedLastTick", this.wrapControllerValue(c -> Float.valueOf(c.getUiStats().getFuelConsumedLastTick()))));
        methodConsumer.accept((Object)new ComputerMethod("getControlRodLocation", this.wrapControllerValue((c, arguments) -> CodeHelper.optionalMap((Optional)c.getMinimumCoord(), c.getControlRodByIndex(LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).map(AbstractMultiblockPart::getWorldPosition), (minCoords, rodCoords) -> rodCoords.m_121996_((Vec3i)minCoords)).orElse(null)), 1));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyCapacity", this.wrapControllerValue(c -> c.getCapacity(c.getOutputEnergySystem()).doubleValue())));
        methodConsumer.accept((Object)new ComputerMethod("getControlRodsLevels", this.wrapControllerValue(c -> {
            int controlRodsCount = c.getControlRodsCount();
            HashMap levels = Maps.newHashMapWithExpectedSize((int)controlRodsCount);
            for (int idx = 0; idx < controlRodsCount; ++idx) {
                levels.put(idx, c.getControlRodByIndex(idx).map(rod -> rod.getInsertionRatio()).orElse(-1));
            }
            return levels;
        })));
        methodConsumer.accept((Object)new ComputerMethod("setControlRodsLevels", this.wrapControllerAction((c, arguments) -> {
            int idx;
            if (!(arguments[0] instanceof Map)) {
                return;
            }
            Map levels = (Map)arguments[0];
            int controlRodsCount = c.getControlRodsCount();
            if (controlRodsCount != levels.size()) {
                throw new IllegalArgumentException("Invalid levels count in a call to setControlRodsLevels()");
            }
            int[] newLevels = new int[controlRodsCount];
            for (idx = 0; idx < newLevels.length; ++idx) {
                double value;
                if (levels.containsKey(idx)) {
                    value = (Double)levels.get(idx);
                } else if (levels.containsKey(idx)) {
                    value = (Double)levels.get(idx);
                } else {
                    throw new IllegalArgumentException("Invalid table key in a call to setControlRodsLevels()");
                }
                newLevels[idx] = (int)Math.round(value);
                if (newLevels[idx] >= 0 && newLevels[idx] <= 100) continue;
                LuaHelper.raiseIllegalArgumentRange((int)idx, (int)0, (int)100);
            }
            for (idx = 0; idx < newLevels.length; ++idx) {
                int newLevel = newLevels[idx];
                c.getControlRodByIndex(idx).ifPresent(rod -> ReactorControlRodEntity.setInsertionRatio(rod, newLevel));
            }
        }), 1, true));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyStats", this.wrapControllerValue(c -> {
            HashMap stats = Maps.newHashMap();
            EnergySystem sys = c.getOutputEnergySystem();
            stats.put("energyStored", c.getEnergyStored(sys).doubleValue());
            stats.put("energyCapacity", c.getCapacity(sys).doubleValue());
            stats.put("energyProducedLastTick", c.getUiStats().getAmountGeneratedLastTick());
            stats.put("energySystem", sys.getUnit());
            return stats;
        })));
        methodConsumer.accept((Object)new ComputerMethod("getFuelStats", this.wrapControllerValue(c -> {
            HashMap stats = Maps.newHashMap();
            stats.put("fuelAmount", c.getFuelAmount());
            stats.put("fuelCapacity", c.getCapacity());
            stats.put("fuelTemperature", c.getFuelHeatValue().getAsDouble());
            stats.put("fuelConsumedLastTick", Float.valueOf(c.getUiStats().getFuelConsumedLastTick()));
            stats.put("fuelReactivity", Float.valueOf(c.getFuelFertility() * 100.0f));
            stats.put("wasteAmount", c.getWasteAmount());
            return stats;
        })));
        methodConsumer.accept((Object)new ComputerMethod("getHotFluidStats", this.wrapControllerValue(c -> {
            HashMap stats = Maps.newHashMap();
            IFluidContainer container = c.getFluidContainer();
            stats.put("fluidType", container.getGas().map(f -> CodeHelper.getObjectId((Fluid)f).toString()));
            stats.put("fluidAmount", container.getGasAmount());
            stats.put("fluidCapacity", container.getCapacity());
            stats.put("fluidProducedLastTick", c.getOperationalMode().isPassive() ? 0.0 : c.getUiStats().getAmountGeneratedLastTick());
            return stats;
        })));
        methodConsumer.accept((Object)new ComputerMethod("getCoolantFluidStats", this.wrapControllerValue(c -> {
            HashMap stats = Maps.newHashMap();
            IFluidContainer container = c.getFluidContainer();
            stats.put("fluidType", container.getLiquid().map(f -> CodeHelper.getObjectId((Fluid)f).toString()));
            stats.put("fluidAmount", container.getLiquidAmount());
            stats.put("fluidCapacity", container.getCapacity());
            return stats;
        })));
        methodConsumer.accept((Object)new ComputerMethod("setActive", this.wrapControllerAction((c, arguments) -> c.setMachineActive(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0))), 1, true));
        methodConsumer.accept((Object)new ComputerMethod("setControlRodLevel", this.wrapControllerAction((c, arguments) -> c.getControlRodByIndex(LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).ifPresent(rod -> ReactorControlRodEntity.setInsertionRatio(rod, LuaHelper.getIntFromArgs((Object[])arguments, (int)1, (int)0, (int)100)))), 2, true));
        methodConsumer.accept((Object)new ComputerMethod("setAllControlRodLevels", this.wrapControllerAction((c, arguments) -> c.setControlRodsInsertionRatio(LuaHelper.getIntFromArgs((Object[])arguments, (int)0, (int)0, (int)100))), 1, true));
        methodConsumer.accept((Object)new ComputerMethod("setControlRodName", this.wrapControllerAction((c, arguments) -> c.getControlRodByIndex(LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).ifPresent(rod -> ReactorControlRodEntity.setName(rod, LuaHelper.getStringFromArgs((Object[])arguments, (int)1)))), 2, true));
        methodConsumer.accept((Object)new ComputerMethod("doEjectWaste", this.wrapControllerAction((c, arguments) -> c.ejectWaste()), 0, true));
        methodConsumer.accept((Object)new ComputerMethod("doEjectFuel", this.wrapControllerAction((c, arguments) -> c.ejectFuel()), 0, true));
    }

    private static BiFunction<MultiblockReactor, Object[], Object> controlRodByIndex(Function<ReactorControlRodEntity, Object> code) {
        return (reactor, arguments) -> reactor.getControlRodByIndex(LuaHelper.getIntFromArgs((Object[])arguments, (int)0)).map(code).orElse(null);
    }
}

