/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.common.capability.FluxPlayer;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.ServerFluxNetwork;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.Messages;

@NotThreadSafe
public final class FluxNetworkData
extends SavedData {
    private static final String NETWORK_DATA = "fluxnetworksdata";
    private static volatile FluxNetworkData data;
    private static final String NETWORKS = "networks";
    private static final String UNIQUE_ID = "uniqueID";
    private final Int2ObjectMap<FluxNetwork> mNetworks = new Int2ObjectOpenHashMap();
    private int mUniqueID = 0;

    private FluxNetworkData() {
    }

    private FluxNetworkData(@Nonnull CompoundTag tag) {
        this.read(tag);
    }

    @Nonnull
    public static FluxNetworkData getInstance() {
        if (data == null) {
            ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129783_();
            data = (FluxNetworkData)level.m_8895_().m_164861_(FluxNetworkData::new, FluxNetworkData::new, NETWORK_DATA);
            FluxNetworks.LOGGER.debug("FluxNetworkData has been successfully loaded");
        }
        return data;
    }

    public static void release() {
        if (data != null) {
            data = null;
            FluxNetworks.LOGGER.debug("FluxNetworkData has been unloaded");
        }
    }

    @Nonnull
    public static FluxNetwork getNetwork(int id) {
        return (FluxNetwork)FluxNetworkData.getInstance().mNetworks.getOrDefault(id, (Object)FluxNetwork.INVALID);
    }

    @Nonnull
    public static Collection<FluxNetwork> getAllNetworks() {
        return FluxNetworkData.getInstance().mNetworks.values();
    }

    @Nullable
    public FluxNetwork createNetwork(@Nonnull Player creator, @Nonnull String name, int color, @Nonnull SecurityLevel security, @Nonnull String password) {
        int max = FluxConfig.maximumPerPlayer;
        if (max != -1 && !FluxPlayer.isPlayerSuperAdmin(creator)) {
            if (max <= 0) {
                return null;
            }
            UUID uuid = creator.m_20148_();
            int i = 0;
            for (FluxNetwork n : this.mNetworks.values()) {
                if (!n.getOwnerUUID().equals(uuid) || ++i < max) continue;
                return null;
            }
        }
        do {
            ++this.mUniqueID;
        } while (this.mNetworks.containsKey(this.mUniqueID));
        ServerFluxNetwork network = new ServerFluxNetwork(this.mUniqueID, name, color, security, creator, password);
        this.mNetworks.put(network.getNetworkID(), (Object)network);
        Channel.get().sendToAll(Messages.updateNetwork(network, (byte)21));
        return network;
    }

    public void deleteNetwork(@Nonnull FluxNetwork network) {
        if (this.mNetworks.remove(network.getNetworkID()) == network) {
            network.onDelete();
            Messages.deleteNetwork(network.getNetworkID());
        }
    }

    public boolean m_77764_() {
        return true;
    }

    private void read(@Nonnull CompoundTag compound) {
        this.mUniqueID = compound.m_128451_(UNIQUE_ID);
        ListTag list = compound.m_128437_(NETWORKS, 10);
        for (int i = 0; i < list.size(); ++i) {
            ServerFluxNetwork network = new ServerFluxNetwork();
            network.readCustomTag(list.m_128728_(i), (byte)1);
            if (network.getNetworkID() <= 0) continue;
            this.mNetworks.put(network.getNetworkID(), (Object)network);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        compound.m_128405_(UNIQUE_ID, this.mUniqueID);
        ListTag list = new ListTag();
        for (FluxNetwork network : this.mNetworks.values()) {
            CompoundTag tag = new CompoundTag();
            network.writeCustomTag(tag, (byte)1);
            list.add((Object)tag);
        }
        compound.m_128365_(NETWORKS, (Tag)list);
        return compound;
    }
}

