/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public abstract class TransferHandler {
    public static final int PRI_USER_MIN = -9999;
    public static final int PRI_USER_MAX = 9999;
    public static final int PRI_GAIN_MIN = 10000;
    public static final int PRI_GAIN_MAX = 100000;
    public static final int STORAGE_PRI_DIFF = 1000000;
    protected long mBuffer;
    protected long mChange;
    private int mPriority;
    private boolean mSurgeMode;
    private long mLimit;
    private boolean mDisableLimit;

    protected TransferHandler(long limit) {
        this.setLimit(limit);
    }

    protected abstract void onCycleStart();

    protected abstract void onCycleEnd();

    protected void addToBuffer(long energy) {
        throw new UnsupportedOperationException();
    }

    protected long removeFromBuffer(long energy) {
        throw new UnsupportedOperationException();
    }

    public final long getBuffer() {
        return this.mBuffer;
    }

    public final long getChange() {
        return this.mChange;
    }

    public long getRequest() {
        return 0L;
    }

    public void onNetworkChanged() {
        this.mChange = 0L;
    }

    public int getPriority() {
        return this.mSurgeMode ? 100000 : this.mPriority;
    }

    public int getRawPriority() {
        return this.mPriority;
    }

    public boolean setPriority(int priority) {
        if (this.mPriority != (priority = Mth.m_14045_((int)priority, (int)-9999, (int)9999))) {
            this.mPriority = priority;
            return true;
        }
        return false;
    }

    public boolean getSurgeMode() {
        return this.mSurgeMode;
    }

    public boolean setSurgeMode(boolean surgeMode) {
        if (this.mSurgeMode != surgeMode) {
            this.mSurgeMode = surgeMode;
            return true;
        }
        return false;
    }

    public long getLimit() {
        return this.mDisableLimit ? Long.MAX_VALUE : this.mLimit;
    }

    public long getRawLimit() {
        return this.mLimit;
    }

    public void setLimit(long limit) {
        this.mLimit = Math.max(0L, limit);
    }

    public boolean getDisableLimit() {
        return this.mDisableLimit;
    }

    public void setDisableLimit(boolean disableLimit) {
        this.mDisableLimit = disableLimit;
    }

    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        switch (type) {
            case 1: 
            case 15: {
                tag.m_128405_("priority", this.mPriority);
                tag.m_128379_("surgeMode", this.mSurgeMode);
                tag.m_128356_("limit", this.mLimit);
                tag.m_128379_("disableLimit", this.mDisableLimit);
                break;
            }
            case 11: 
            case 20: {
                tag.m_128356_("change", this.mChange);
                tag.m_128405_("priority", this.mPriority);
                tag.m_128379_("surgeMode", this.mSurgeMode);
                tag.m_128356_("limit", this.mLimit);
                tag.m_128379_("disableLimit", this.mDisableLimit);
            }
        }
    }

    public void readCustomTag(@Nonnull CompoundTag tag, byte type) {
        assert (type != 19);
        this.mBuffer = tag.m_128441_("buffer") ? tag.m_128454_("buffer") : tag.m_128454_("energy");
        switch (type) {
            case 1: 
            case 15: {
                this.mPriority = tag.m_128451_("priority");
                this.mSurgeMode = tag.m_128471_("surgeMode");
                this.mLimit = tag.m_128454_("limit");
                this.mDisableLimit = tag.m_128471_("disableLimit");
                break;
            }
            case 11: {
                this.mChange = tag.m_128454_("change");
                this.mPriority = tag.m_128451_("priority");
                this.mSurgeMode = tag.m_128471_("surgeMode");
                this.mLimit = tag.m_128454_("limit");
                this.mDisableLimit = tag.m_128471_("disableLimit");
            }
        }
    }

    public boolean changeSettings(@Nonnull CompoundTag tag) {
        boolean sort = false;
        if (tag.m_128441_("surgeMode")) {
            sort = this.setSurgeMode(tag.m_128471_("surgeMode"));
        }
        if (tag.m_128441_("priority")) {
            sort |= this.setPriority(tag.m_128451_("priority"));
        }
        if (tag.m_128441_("disableLimit")) {
            this.setDisableLimit(tag.m_128471_("disableLimit"));
        }
        if (tag.m_128441_("limit")) {
            this.setLimit(tag.m_128454_("limit"));
        }
        return sort;
    }

    public void writePacketBuffer(@Nonnull FriendlyByteBuf buf, byte type) {
        if (type == -1) {
            buf.writeLong(this.mChange);
            buf.writeLong(this.mBuffer);
        }
    }

    public void readPacketBuffer(@Nonnull FriendlyByteBuf buf, byte type) {
        if (type == -1) {
            this.mChange = buf.readLong();
            this.mBuffer = buf.readLong();
        }
    }
}

