/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.ApiStatus;
import xfacthd.framedblocks.api.shapes.ShapeReloader;

public final class ShapeCache<K> {
    private final Map<K, VoxelShape> cache;
    private final Consumer<Map<K, VoxelShape>> generator;

    public ShapeCache(Consumer<Map<K, VoxelShape>> generator) {
        this(new HashMap(), generator);
    }

    public ShapeCache(Map<K, VoxelShape> cache, Consumer<Map<K, VoxelShape>> generator) {
        this.cache = cache;
        this.generator = generator;
        generator.accept(cache);
        if (!FMLEnvironment.production) {
            ShapeReloader.addCache(this);
        }
    }

    public VoxelShape get(K key) {
        return this.cache.get(key);
    }

    @ApiStatus.Internal
    void reload() {
        this.cache.clear();
        this.generator.accept(this.cache);
    }
}

