/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.FramedDoubleBlockRenderProperties;

public abstract class AbstractFramedDoubleBlock
extends FramedBlock
implements IFramedDoubleBlock {
    public AbstractFramedDoubleBlock(BlockType blockType) {
        super(blockType);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.SOLID});
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            return be.getSoundType();
        }
        return this.m_49962_(state);
    }

    @Override
    @Nullable
    public BlockState runOcclusionTestAndGetLookupState(SideSkipPredicate pred, BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Tuple statePair = this.getBlockPair(adjState);
        if (pred.test(level, pos, state, (BlockState)statePair.m_14418_(), side)) {
            return (BlockState)statePair.m_14418_();
        }
        if (pred.test(level, pos, state, (BlockState)statePair.m_14419_(), side)) {
            return (BlockState)statePair.m_14419_();
        }
        return null;
    }

    @Override
    public boolean playBreakSound(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            BlockState stateOne = be.getCamo().getState();
            if (stateOne.m_60795_()) {
                stateOne = ((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_49966_();
            }
            IFramedBlock.playCamoBreakSound(level, pos, stateOne);
            BlockState stateTwo = be.getCamoTwo().getState();
            if (stateTwo.m_60795_()) {
                stateTwo = ((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_49966_();
            }
            if (stateTwo.m_60827_() != stateOne.m_60827_()) {
                IFramedBlock.playCamoBreakSound(level, pos, stateTwo);
            }
            return true;
        }
        return false;
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedDoubleBlockRenderProperties.INSTANCE);
    }

    @Override
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public static Tuple<BlockState, BlockState> getStatePair(BlockState state) {
        return ((IFramedDoubleBlock)state.m_60734_()).getCache(state).getBlockPair();
    }
}

