/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pane;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedFloorBlock
extends FramedBlock {
    public FramedFloorBlock() {
        super(BlockType.FRAMED_FLOOR_BOARD);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.TOP, BlockStateProperties.f_61362_, FramedProperties.SOLID});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction side = context.m_43719_();
        boolean top = false;
        if (side == Direction.DOWN) {
            top = true;
        } else if (!Utils.isY(side)) {
            Vec3 vec = Utils.fraction(context.m_43720_());
            top = vec.f_82480_ > 0.5;
        }
        state = (BlockState)state.m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top));
        return FramedFloorBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        return !level.m_46859_(top ? pos.m_7494_() : pos.m_7495_());
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction side, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, side, neighborState, level, pos, neighborPos);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBottom = FramedFloorBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape shapeTop = FramedFloorBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator unmodifiableIterator = states.iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            boolean top = (Boolean)(state = (BlockState)unmodifiableIterator.next()).m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)(top ? shapeTop : shapeBottom));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

