/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.rail;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.block.rail.FramedFancyRailSlopeBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedFancyRailSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedRailSlopeBlock
extends BaseRailBlock
implements IFramedBlock,
ISlopeBlock.IRailSlopeBlock {
    private final BlockType type;
    private final ShapeProvider shapes;
    private final BiFunction<BlockPos, BlockState, FramedBlockEntity> beFactory;

    protected FramedRailSlopeBlock(BlockType type, BiFunction<BlockPos, BlockState, FramedBlockEntity> beFactory) {
        super(true, IFramedBlock.createProperties(type));
        this.type = type;
        this.shapes = type.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
        this.beFactory = beFactory;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.ASCENDING_RAIL_SHAPE, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING, FramedProperties.Y_SLOPE, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        RailShape shape = FramedUtils.getAscendingRailShapeFromDirection(context.m_8125_());
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean waterlogged = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)shape)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState newState = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        if (newState == state) {
            this.updateCulling((LevelReader)level, currentPos);
        }
        return newState;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pFromPos, boolean isMoving) {
        this.updateCulling((LevelReader)level, pos);
        if (!level.m_5776_() && level.m_8055_(pos).m_60713_((Block)this)) {
            this.m_6360_(state, level, pos, block);
        }
    }

    public Property<RailShape> m_7978_() {
        return PropertyHolder.ASCENDING_RAIL_SHAPE;
    }

    public boolean isValidRailShape(RailShape shape) {
        return shape.m_61745_();
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public boolean m_7923_(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.m_7749_(state, level, pos));
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.m_49635_(state, builder), builder);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ctx;
        if (context instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)context).m_193113_() instanceof AbstractMinecart) {
            return Shapes.m_83040_();
        }
        return this.m_5940_(state, worldIn, pos, context);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = FramedUtils.getDirectionFromAscendingRailShape((RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE));
        dir = rot.m_55954_(dir);
        return (BlockState)state.m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedUtils.getAscendingRailShapeFromDirection(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = FramedUtils.getDirectionFromAscendingRailShape((RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE));
        if (mirror == Mirror.FRONT_BACK && Utils.isZ(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isX(dir)) {
            dir = dir.m_122424_();
            return (BlockState)state.m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedUtils.getAscendingRailShapeFromDirection(dir));
        }
        return state;
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.beFactory.apply(pos, state);
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedBlockRenderProperties.INSTANCE);
    }

    public static FramedRailSlopeBlock normal() {
        return new FramedRailSlopeBlock(BlockType.FRAMED_RAIL_SLOPE, FramedBlockEntity::new);
    }

    public static FramedRailSlopeBlock fancy() {
        return new FramedFancyRailSlopeBlock(BlockType.FRAMED_FANCY_RAIL_SLOPE, FramedFancyRailSlopeBlockEntity::new);
    }

    public static BlockState itemModelSourceFancy() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_FANCY_RAIL_SLOPE.get()).m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
    }
}

